import RPi.GPIO as GPIO 
import time 
import commands 
import re 
import smtplib 
import time 
from datetime import datetime 
import os 
os.system('modprobe w1-gpio')      #load the temperature prob
os.system('modprobe w1-therm')   #load the temperature prob
 
GPIO.setwarnings(False) # ignoring the warnings 
 
# Define GPIO to LCD mapping 
LCD_RS = 7 
LCD_E  = 8 
LCD_D4 = 25  
LCD_D5 = 24 
LCD_D6 = 23 
LCD_D7 = 18 
# Define some device constants 
LCD_WIDTH = 16   
LCD_CHR = True 
LCD_CMD = False 

 #LCD RAM address for lines. Depending upon your LCD panel remove the other lines.
LCD_LINE_1 = 0x80  #  1st line 
LCD_LINE_2 = 0xC0 # 2nd line  
LCD_LINE_3 = 0x94  # 3rd line
LCD_LINE_4 = 0xD4  # 4th line
# Timing constants 
E_PULSE = 0.00005 
E_DELAY = 0.00005 

 # Main program block 
def lcd_init(): 
  GPIO.setmode(GPIO.BCM)       # Use BCM GPIO numbers 
  GPIO.setup(LCD_E, GPIO.OUT)  # E 
  GPIO.setup(LCD_RS, GPIO.OUT) # RS 
  GPIO.setup(LCD_D4, GPIO.OUT) # DB4 
  GPIO.setup(LCD_D5, GPIO.OUT) # DB5 
  GPIO.setup(LCD_D6, GPIO.OUT) # DB6 
  GPIO.setup(LCD_D7, GPIO.OUT) # DB7 
 
  # Initialise display 
  # Initialise display 
  lcd_byte(0x33,LCD_CMD) 
  lcd_byte(0x32,LCD_CMD) 
  lcd_byte(0x28,LCD_CMD) 
  lcd_byte(0x0C,LCD_CMD)   
  lcd_byte(0x06,LCD_CMD) 
  lcd_byte(0x01,LCD_CMD)   
 
def lcd_string(message,style): 
	if style==1: 
		message = message.ljust(LCD_WIDTH," ") 
	elif style==2: 
		message = message.center(LCD_WIDTH," ") 
	elif style==3: 
		message = message.rjust(LCD_WIDTH," ") 
  # Send string to display 
#  message = message.ljust(LCD_WIDTH," ")   
  	for i in range(LCD_WIDTH): 
    		lcd_byte(ord(message[i]),LCD_CHR) 
 
def lcd_byte(bits, mode): 
  GPIO.output(LCD_RS, mode) # RS 
 
  # High bits 
  GPIO.output(LCD_D4, False) 
  GPIO.output(LCD_D5, False) 
  GPIO.output(LCD_D6, False) 
  GPIO.output(LCD_D7, False) 
  if bits&0x10==0x10: 
    GPIO.output(LCD_D4, True) 
  if bits&0x20==0x20: 
    GPIO.output(LCD_D5, True) 
  if bits&0x40==0x40: 
    GPIO.output(LCD_D6, True) 
  if bits&0x80==0x80: 
    GPIO.output(LCD_D7, True) 
 
  # Toggle 'Enable' pin 
  time.sleep(E_DELAY)     
  GPIO.output(LCD_E, True)   
  time.sleep(E_PULSE) 
  GPIO.output(LCD_E, False)   
  time.sleep(E_DELAY)       
 
  # Low bits 
  GPIO.output(LCD_D4, False) 
  GPIO.output(LCD_D5, False) 
  GPIO.output(LCD_D6, False) 
  GPIO.output(LCD_D7, False) 
  if bits&0x01==0x01: 
    GPIO.output(LCD_D4, True) 
  if bits&0x02==0x02: 
    GPIO.output(LCD_D5, True) 
  if bits&0x04==0x04: 
    GPIO.output(LCD_D6, True) 
  if bits&0x08==0x08: 
    GPIO.output(LCD_D7, True) 
 
  # Toggle 'Enable' pin 
  time.sleep(E_DELAY)     
  GPIO.output(LCD_E, True)   
  time.sleep(E_PULSE) 
  GPIO.output(LCD_E, False)   
  time.sleep(E_DELAY)    
#end of program iptalk1.py
