#ifdef __cplusplus
extern "C" {
uint8_t temprature_sens_read();
}
#endif
  
#include <ArduinoJson.h>
#include <WiFi.h>
#include <WiFiClient.h>
#include <HTTPClient.h>

#include <SD.h>
#include <SPI.h>

//---------------------------------
#include <Wire.h> // must be included here so that Arduino library object file references work
#include <RtcDS3231.h>
RtcDS3231<TwoWire> Rtc(Wire);
#define countof(a) (sizeof(a) / sizeof(a[0]))
uint8_t hh,mm,ss;  //containers for current time
String dow[7]  = {"Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"};  // Sunday is dayOfWeek 0
String moy[12] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"}; // January is month 0
//----------------------------------


#include <Adafruit_GFX.h>    // Core graphics library
#include "Adafruit_ILI9341.h" // Hardware-specific library
Adafruit_ILI9341 tft = Adafruit_ILI9341(4,15,2);



// Replace with your SSID and password details
char ssid[] = "......";      //enter your wifi ssid
char pass[] = ".........."; //enter your wifi password

WiFiClient client;

const char server[] = "api.openweathermap.org";
String nameOfCity = "Singrauli,IN"; //Almaty,KZ  enter your city code
String apiKey = "................................"; //enter your api key of openweathermap.org
String text;

int jsonend = 0;
boolean startJson = false;
int status = WL_IDLE_STATUS;

int rainLed = 2;  // Indicates rain
int clearLed = 3; // Indicates clear sky or sunny
int snowLed = 4;  // Indicates snow
int hailLed = 5;  // Indicates hail

int len,i,j,k,tm,th,ts;

#define JSON_BUFF_DIMENSION 2500

unsigned long lastConnectionTime = 10 * 60 * 1000;     // last time you connected to the server, in milliseconds
const unsigned long postInterval = 10 * 60 * 1000;  // posting interval of 10 minutes  (10L * 1000L; 10 seconds delay for testing)

//String a[37];
//String b[37];



void setup() {
  Serial.begin(115200);
  tft.begin();
  tft.setCursor(0, 0);
  tft.fillScreen(ILI9341_BLACK);
  tft.setTextColor(ILI9341_BLUE); 
  tft.setRotation(0);   
  tft.setTextSize(2);
  tft.setRotation(3); 

//------------------------------------------------------
 Rtc.Begin();
    RtcDateTime compiled = RtcDateTime(__DATE__, __TIME__);
//    printDateTime(compiled);
    Serial.println();

    if (!Rtc.IsDateTimeValid()) {
        // Common Cuases:
        //    1) first time you ran and the device wasn't running yet
        //    2) the battery on the device is low or even missing
        Serial.println("RTC lost confidence in the DateTime!");
        // following line sets the RTC to the date & time this sketch was compiled
        // it will also reset the valid flag internally unless the Rtc device is
        // having an issue
        Rtc.SetDateTime(compiled);
    }
   if (!Rtc.GetIsRunning())  {
        Serial.println("RTC was not actively running,  now");
        Rtc.SetIsRunning(true);   //starting
    }
    RtcDateTime now = Rtc.GetDateTime();
    if (now < compiled)     {
        Serial.println("RTC is older than compile time!  (Updating DateTime)");
        Rtc.SetDateTime(compiled);
    }
    else if (now > compiled) {
        Serial.println("RTC is newer than compile time. (this is expected)");
    }
    else if (now == compiled) {
        Serial.println("RTC is the same as compile time! (not expected but all is fine)");
    }

    // never assume the Rtc was last configured by you, so
    // just clear them to your needed state
    Rtc.Enable32kHzPin(false);
    Rtc.SetSquareWavePin(DS3231SquareWavePin_ModeNone); 
//--------------------------------------------------------------


  
  text.reserve(JSON_BUFF_DIMENSION);
  
  WiFi.begin(ssid,pass);
  Serial.println("connecting");
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("WiFi Connected");
  printWiFiStatus();
}

void loop() { 
  clock1();
   if (millis() - lastConnectionTime > 60000) {   
    //60000 milli seconds page flipping
    lastConnectionTime = millis();
    Serial.println(lastConnectionTime);
    Serial.println(postInterval);
    
   if (tm%2==1) {Serial.println("Page-2"); page2();  }
   if (tm%2==0) {Serial.println("Page-1"); page1();  }
  }
}

// print Wifi status
void printWiFiStatus() {
// print the SSID of the network you're attached to:
 Serial.print("SSID: ");
 Serial.println(WiFi.SSID());

// print your WiFi shield's IP address:
  IPAddress ip = WiFi.localIP();
  Serial.print("IP Address: ");
  Serial.println(ip);

// print the received signal strength:
  long rssi = WiFi.RSSI();
  Serial.print("signal strength (RSSI):");
  Serial.print(rssi);
  Serial.println(" dBm");
}

// to request data from OWM
void page1() {
 client.stop();
  DynamicJsonBuffer jsonBuffer;
  if (client.connect(server, 80)) {
       String poststr="http://";
       poststr=poststr+server;
       poststr=poststr+"/data/2.5/forecast?q=" + nameOfCity + "&APPID=" + apiKey + "&mode=json&units=metric&cnt=37";  
//    Serial.println(poststr);
    HTTPClient http;  //Declare an object of class HTTPClient
    http.begin(poststr);
    int  httpCode=http.GET();

      if (httpCode > 0) { //Check for the returning code
        String payload = http.getString();


JsonObject& root = jsonBuffer.parseObject(payload);
len=payload.length();
//Serial.println(len);
//Serial.println(payload);
 
   if (!root.success()) { 
     Serial.println("parseObject() failed"); 
     return; 
   } 


String buf;
char buf1[100];
String x="";;
tft.setTextSize(1);
tft.fillScreen(ILI9341_BLACK);
k=0;
for(i=0;i<=22;i++){  //23 to 36 in 2nd page
String a = root["list"][i]["dt_txt"]; 
String dt = a.substring(2,10);
int tm = a.substring(11,13).toInt(); 
String b = root["list"][i]["weather"][0]["description"]; 
String c = root["list"][i]["main"]["temp_max"]; 
String d = root["list"][i]["main"]["temp_min"];
String e = root["list"][i]["main"]["temp"];
String f = root["list"][i]["wind"]["speed"];
String g = root["list"][i]["main"]["humidity"];
String h = root["city"]["name"]; 
if(tm<10) buf=x+"0"+tm+":00 "+c+" "+d+" "+e+" "+g+"% "+f+" "+b;
if(tm>9)  buf=x+tm+":00 "+c+" "+d+" "+e+" "+g+"% "+f+" "+b;

if(tm==0) k = k+1;

sprintf(buf1," %2d:00 %5.2f %5.2f %5.2f %2d %5.2f ",tm,c.toFloat(),d.toFloat(),e.toFloat(),g.toInt(),f.toFloat());

if(i==0 ) {
tft.setTextColor(ILI9341_WHITE,ILI9341_BLACK); 
tft.setCursor(135,5);
tft.print(dt);
tft.print("  ");
tft.print(h);
tft.print(" Page-1");
tft.setCursor(5,15);
tft.println("Time  MaxT  MinT  Mean  RH  Wind Weather");  
}

if(tm==0) {
tft.setCursor(120,tft.getCursorY()+8);
tft.setTextColor(ILI9341_MAGENTA,ILI9341_BLACK); 
tft.print(dt);
tft.print("  ");
tft.println(h);
}



if(i==1 || i==5 || i==9 ||i==13 ) {
tft.setTextColor(ILI9341_YELLOW,ILI9341_BLACK); 
}

if(i==2 || i==6 || i==10 |i==14 ) {
tft.setTextColor(ILI9341_BLUE,ILI9341_BLACK); 
}

if(i==3 || i==7 || i==11 |i==15 ) {
tft.setTextColor(ILI9341_GREEN,ILI9341_BLACK); 
}

if(i==4 || i==8 || i==12 |i==16 ) {
tft.setTextColor(ILI9341_WHITE,ILI9341_BLACK); 
}


if(i==17 || i==21 || i==25 || i==29 ||i==33) {
tft.setTextColor(ILI9341_GREEN,ILI9341_BLACK); 
}

if(i==18 || i==22 || i==26 || i==30 ||i==34) {
tft.setTextColor(ILI9341_CYAN,ILI9341_BLACK); 
}

if(i==19 || i==23 || i==27 || i==31 || i==35) {
tft.setTextColor(ILI9341_MAGENTA,ILI9341_BLACK); 
}

if(i==20 || i==24 || i==28 |i==32 || i==36) {
tft.setTextColor(ILI9341_ORANGE, ILI9341_BLACK); 
}

tft.print(buf1);
tft.println(b);
tft.drawRect(0,0,319,240,ILI9341_YELLOW);
        }
       }
   }
//  if ( tm%2==1 ) {Serial.println("Page-2"); page2();  }  
}


void page2() {
 client.stop();
  DynamicJsonBuffer jsonBuffer;
  if (client.connect(server, 80)) {
       String poststr="http://";
       poststr=poststr+server;
       poststr=poststr+"/data/2.5/forecast?q=" + nameOfCity + "&APPID=" + apiKey + "&mode=json&units=metric&cnt=37";  
    //Serial.println(poststr);
    HTTPClient http;  //Declare an object of class HTTPClient
    http.begin(poststr);
    int  httpCode=http.GET();

      if (httpCode > 0) { //Check for the returning code
        String payload = http.getString();


JsonObject& root = jsonBuffer.parseObject(payload);
len=payload.length();
//Serial.println(len);
//Serial.println(payload);
 
   if (!root.success()) { 
     Serial.println("parseObject() failed"); 
     return; 
   } 


String buf;
char buf1[100];
String x="";;
tft.setTextSize(1);
tft.fillScreen(ILI9341_BLACK);;
k=0;
for(i=20;i<=36;i++){  //36
String a = root["list"][i]["dt_txt"]; 
String dt = a.substring(2,10);
int tm = a.substring(11,13).toInt(); 
String b = root["list"][i]["weather"][0]["description"]; 
String c = root["list"][i]["main"]["temp_max"]; 
String d = root["list"][i]["main"]["temp_min"];
String e = root["list"][i]["main"]["temp"];
String f = root["list"][i]["wind"]["speed"];
String g = root["list"][i]["main"]["humidity"];
String h = root["city"]["name"]; 
if(tm<10) buf=x+"0"+tm+":00 "+c+" "+d+" "+e+" "+g+"% "+f+" "+b;
if(tm>9)  buf=x+tm+":00 "+c+" "+d+" "+e+" "+g+"% "+f+" "+b;

if(tm==0) k = k+1;

sprintf(buf1," %2d:00 %5.2f %5.2f %5.2f %2d %5.2f ",tm,c.toFloat(),d.toFloat(),e.toFloat(),g.toInt(),f.toFloat());

if(i==0 || i==20) {
tft.setTextColor(ILI9341_WHITE,ILI9341_BLACK); 
tft.setCursor(135,5);
tft.print(dt);
tft.print("  ");
tft.print(h);
tft.print(" Page-2");
tft.setCursor(5,15);
tft.println("Time  MaxT  MinT  Mean  RH  Wind Weather");  
}

if(tm==0) {
tft.setCursor(120,tft.getCursorY()+8);
tft.setTextColor(ILI9341_MAGENTA,ILI9341_BLACK); 
tft.print(dt);
tft.print("  ");
tft.println(h);
}



if(i==1 || i==5 || i==9 ||i==13 ) {
tft.setTextColor(ILI9341_YELLOW,ILI9341_BLACK); 
}

if(i==2 || i==6 || i==10 |i==14 ) {
tft.setTextColor(ILI9341_BLUE,ILI9341_BLACK); 
}

if(i==3 || i==7 || i==11 |i==15 ) {
tft.setTextColor(ILI9341_GREEN,ILI9341_BLACK); 
}

if(i==4 || i==8 || i==12 |i==16 ) {
tft.setTextColor(ILI9341_WHITE,ILI9341_BLACK); 
}


if(i==17 || i==21 || i==25 || i==29 ||i==33) {
tft.setTextColor(ILI9341_GREEN,ILI9341_BLACK); 
}

if(i==18 || i==22 || i==26 || i==30 ||i==34) {
tft.setTextColor(ILI9341_CYAN,ILI9341_BLACK); 
}

if(i==19 || i==23 || i==27 || i==31 || i==35) {
tft.setTextColor(ILI9341_MAGENTA,ILI9341_BLACK); 
}

if(i==20 || i==24 || i==28 |i==32 || i==36) {
tft.setTextColor(ILI9341_ORANGE, ILI9341_BLACK); 
}

tft.print(buf1);
tft.println(b);
tft.drawRect(0,0,319,240,ILI9341_YELLOW);
        }
      
      }
   }
//if ( tm%2==0 ) {Serial.println("Page-1"); page1();  }
   
}


void thickline(int16_t x0, int16_t y0, int16_t x1, int16_t y1, int pixel, uint16_t color){
for(int i=0;i<=pixel/2;i++){
double l1=atan((y1-y0)/(x1-x0));
tft.drawLine( x0-i/2*sin(l1),y0+i/2*cos(l1),x1-i/2*sin(l1),y1+i/2*cos(l1), color);
tft.drawLine( x0+i/2*sin(l1),y0-i/2*cos(l1),x1+i/2*sin(l1),y1-i/2*cos(l1),color);

  }
}

void printDigits(int digits){
  if(digits < 10)
    tft.print('0');
    tft.print(digits);
}


void clock1(){
RtcDateTime now = Rtc.GetDateTime();  
th = now.Hour();
tm = now.Minute();
ts = now.Second();
RtcTemperature temp = Rtc.GetTemperature();
tft.setCursor(5,5);
tft.setTextSize(1);
tft.setTextColor(ILI9341_RED,ILI9341_BLACK); 
 printDigits(th);
 tft.print(":");
 printDigits(tm);
 tft.print(":");
 printDigits(ts);
tft.print(" ");
tft.print(dow[now.DayOfWeek()]);
tft.print(" ");
tft.print(temp.AsFloat());
}


