
import matplotlib.pyplot as plt
from Calling_program2 import *

def L_layer_deep_NN(X, Y, learning_rate, layer_dims, iterations, print_cost):

    np.random.seed(1)
    costs = []
    # Parameter initialization
    parameters = initialize_param_deep(layer_dims)

    # L layer neural netwok modelling
    for i in range(0, iterations):

          # Forward propagation
          AL, caches = L_forward_layer_model(X, parameters)

          # Cost computation
          cost = compute_cost(AL, Y)

          # Backpropagation
          grads = L_backward_layer_model(AL, Y, caches)

          # Gradient descent
          parameters = parameter_update(parameters, grads, learning_rate)


          if print_cost and i % 100 == 0:
             print("Cost after iteration {}: {}".format(i, np.squeeze(cost)))
          if print_cost and i % 100 == 0:
            costs.append(cost)

    return parameters










