
import numpy as np
import h5py

# Sigmoid implementaion
def sigmoid(Z):

    A = 1/(1+np.exp(-Z))
    cache = Z
    return A , cache

def sigmoid_bck(dA,cache):
    var1,c = sigmoid(cache)
    deriv_sigmoid = var1*(1-var1)
    dZ = dA *deriv_sigmoid
    return dZ


def relu_bck(dA, cache):
    Z = cache
    dZ = np.array(dA, copy=True)
    dZ[Z <= 0] = 0
    return dZ

def relu(Z):
    A = np.maximum(0,Z)
    cache = Z
    return A, cache

# Initialize parameters for a 2 layer neural network

def linear_forward_model(A, W, b):
    Z = np.dot(W, A)+b
    cache = (A, W, b)
    return Z, cache


def linear_activation_fwd(A_prev, W, b, activation):

    if activation == "sigmoid":
        Z, lin_cache = linear_forward_model(A_prev, W, b)
        A, active_cache = sigmoid(Z)

    elif activation == "relu":
        Z, lin_cache = linear_forward_model(A_prev, W, b)
        A, active_cache = relu(Z)

    cache = (lin_cache, active_cache)
    return A, cache


def linear_backward_model(dZ, cache):
    A_prev, W, b = cache
    m = A_prev.shape[1]
    dW = (1./m)*np.dot(dZ, A_prev.T)
    db = (1./m)*np.sum(dZ, axis = 1, keepdims = True)
    dA_prev = np.dot(W.T, dZ)

    return dA_prev, dW, db


def linear_activation_bck(dA, cache, activation):
    linear_cache, active_cache = cache

    if activation == "sigmoid":
        dZ = sigmoid_bck(dA, active_cache)
    elif activation == "relu":
        dZ = relu_bck(dA, active_cache)

    dA_prev, dW, db = linear_backward_model(dZ, linear_cache)

    return dA_prev, dW, db


# Initialize parmaters for L layer network


def initialize_param_deep(layer_dimension):
    np.random.seed(1)
    parameters = {}
    L = len(layer_dimension)
    for i in range(1, L):
        parameters["W" + str(i)] = np.random.randn(layer_dimension[i],layer_dimension[i-1])*np.sqrt(1/layer_dimension[i-1])
        parameters["b" + str(i)] = np.zeros((layer_dimension[i],1))
    return parameters


def L_forward_layer_model(X, parameters):

    caches = []
    A = X    # initial block has input as features itself
    L = len(parameters) //2

    for i in range(1, L):
        A_prev = A
        A, cache = linear_activation_fwd(A_prev, parameters["W"+str(i)], parameters["b"+str(i)], activation = "relu")
        caches.append(cache)

    AL, cache = linear_activation_fwd(A, parameters["W" + str(L)], parameters["b" + str(L)], activation="sigmoid")
    caches.append(cache)
    return AL, caches


def compute_cost(AL, Y):
    m = Y.shape[1]
    cost = (np.dot(Y, np.log(AL.T)) + np.dot(1 - Y, np.log(1 - AL.T))) * (-1 / m)
    return cost


def L_backward_layer_model(AL, Y, caches):

    grads = {}
    L = len(caches)
    Y = Y.reshape(AL.shape)
    dAL = -np.divide(Y, AL) + np.divide(1-Y, 1-AL)

    # For last layer
    current_cache = caches[-1]   # caches[L-1] is also same
    grads["dA" + str(L-1)],grads["dW" + str(L)],grads["db"+ str(L)] = linear_activation_bck(dAL, current_cache, "sigmoid")

    for l in reversed(range(L-1)):

        current_cache = caches[l]
        dA_temp, dW_temp, db_temp = linear_activation_bck(grads["dA"+str(l+1)],current_cache, "relu")
        grads["dA" + str(l)] = dA_temp
        grads["dW" + str(l+1)] = dW_temp
        grads["db" + str(l+1)] = db_temp

    return grads

def parameter_update(parameters, grads, learning_rate):

    L = len(parameters)//2

    for l in range(L):
        parameters["W" + str(l+1)] = parameters["W"+ str(l+1)] - learning_rate * grads["dW" + str(l+1)]
        parameters["b" + str(l + 1)] = parameters["b" + str(l + 1)] - learning_rate * grads["db" + str(l + 1)]

    return parameters

# Predicting the output

def predict(parameters, X, Y):

    m = X.shape[1]
    prob = np.zeros((1, m))

    AL, caches =  L_forward_layer_model(X, parameters)
    for i in range(0, AL.shape[1]):
        if AL[0,i] < 0.5:
            prob[0,i] = 0
        else:
            prob[0,i] = 1

    accuracy = np.sum((prob == Y)/m)
    return accuracy


# Loading the dataset

def load_data():
    train_dataset = h5py.File('training_data.h5', "r")
    train_set_x_orig = np.array(train_dataset["train_set_x"][:])  # your train set features
    train_set_y_orig = np.array(train_dataset["train_set_y"][:])  # your train set labels

    test_dataset = h5py.File('testing_data.h5', "r")
    test_set_x_orig = np.array(test_dataset["test_set_x"][:])  # your test set features
    test_set_y_orig = np.array(test_dataset["test_set_y"][:])  # your test set labels

    classes = np.array(test_dataset["list_classes"][:])  # the list of classes

    train_set_y_orig = train_set_y_orig.reshape((1, train_set_y_orig.shape[0]))
    test_set_y_orig = test_set_y_orig.reshape((1, test_set_y_orig.shape[0]))

    return train_set_x_orig, train_set_y_orig, test_set_x_orig, test_set_y_orig, classes



