#include <ESP8266WiFi.h>
#include <ESP8266HTTPClient.h>

#include <OneWire.h>
#include <DHT.h>
#define DHTPIN D5   // what pin we're connected to
#define DHTTYPE DHT22   // DHT 22  (AM2302)

#include <EEPROM.h>
#include <NTPClient.h>
#include <Time.h>
#include <WiFiUdp.h>

const char* ssid = "bera";
const char* pass = "..........";    // your network password

const char* ssid1= "beramobile";
const char* pass1 = "..........";   // your network password

char tm[10];
char dt[10];
int addr = 0;
int i;
int counter;
int httpCode;
WiFiUDP ntpUDP;

// You can specify the time server pool and the offset (in seconds, can be
// changed later with setTimeOffset() ). Additionaly you can specify the
// update interval (in milliseconds, can be changed using setUpdateInterval() ).
NTPClient timeClient(ntpUDP, "europe.pool.ntp.org", 5.5*3600, 60000); //Add 5 hrs 30 minutes to IST

DHT dht(DHTPIN, DHTTYPE,11);   //this 11 is for ESP8266
ADC_MODE(ADC_VCC);

HTTPClient http;  //Declare an object of class HTTPClient

String st1;


 
void setup () {
EEPROM.begin(512);  
counter=EEPROM.read(addr);
Serial.begin(115200);
Serial.println();
Serial.printf("Current counter value: %u\n", counter);

if(counter==0 or counter==1)   WiFi.begin(ssid, pass);
if(counter==2)                 WiFi.begin(ssid1, pass1);
 
dht.begin();
EEPROM.begin(512);
while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
    i=i+1;
    Serial.print(i);
    if(i>=40) {
if(counter==0 or counter==1)   EEPROM.write(addr,2);
if(counter==2 )                EEPROM.write(addr,1);
EEPROM.end();
ESP.restart();     //Restart ESP it does not get connected for long
    }
}
//timeClient.begin(); 
float a_hmdty  = dht.readHumidity();   
float a_temp = dht.readTemperature();  // Read temperature as Celsius 
float temp_f = dht.readTemperature(true);// Read temperature as Fahrenheit
float b_volt = ESP.getVcc();

Serial.print(a_temp,2);
Serial.print(",");
Serial.print(a_hmdty,2);
Serial.print(",");
Serial.println(b_volt/1000,3);

if (WiFi.status() == WL_CONNECTED) { //Check WiFi connection status
timeClient.begin();
timeClient.update();
st1=timeClient.getFormattedTime();
Serial.println(st1);

setTime(timeClient.getEpochTime());  
time_t t = now(); //Set the time;
sprintf(tm, "%d:%d:%d",hour(t),minute(t),second(t));
sprintf(dt, "%d/%d/%d",year(t),month(t),day(t));
Serial.print("Date:");
Serial.print(dt);
Serial.print("  Time:");
Serial.println(st1);
//delay(1000);
}

logdata(a_temp,a_hmdty,b_volt);
//delay(60000);
WiFi.forceSleepBegin();  //Putting the Modem off
delay(120000);
//WiFi.forceSleepWake();  //waking up the modem
ESP.restart();
}


void logdata(float temp,float hmdty,float volt) {
//String poststr="http://192.168.1.47:8082/gps/arduino/c1z2.php?";   //Internet server
String poststr="http://berapi.ddns.net:8082/gps/arduino/c1z2.php?";  //Intranet Server
poststr +="dt='"+(String)dt+"'";
poststr +="&tm='"+st1+"'";
poststr +="&user=cloud1user";
poststr +="&pass=cloud1_123";
poststr +="&a_temp="+String(temp);
poststr +="&a_hmdty="+String(hmdty);
poststr +="&vcc="+String(volt/1000);

Serial.println(poststr);
http.begin(poststr); //gps/arduino/c1z1.php?dt='2017-10-3'&tm='20:31:59'&user=cloud1user&pass=cloud1_123&a_temp=31.50&a_hmdty=46.70&a_smoke=2559&o_temp=42.78&vcc=3.75");  //Specify request destination

    httpCode = http.GET();       //Send the request
    Serial.println(httpCode);

    if (httpCode > 0) { //Check the returning code
    String payload = http.getString();   //Get the request response payload
    Serial.println(payload);                     //Print the response payload
    http.end();   //Close connection
    }

  
else {
      Serial.print("HTTP Code:");
      Serial.println("Error on HTTP request");
      EEPROM.begin(512); 
      if(counter==0 or counter==1)   EEPROM.write(addr,2);
      if(counter==2)                 EEPROM.write(addr,1);
      EEPROM.end();
      ESP.restart();

    }
   
}

void loop() {
}

