<?php
require_once("../lib/phpchartdir.php");
# SQL statement to get the monthly revenues for the selected year.
$sql ="Select a_temp, a_hmdty, a_smoke,time,o_temp,id From cloud1.zone1 Order by id desc limit 25";
//echo $sql;
$con = new mysqli("192.168.1.47", "cloud1user", "cloud1_123", "cloud1");
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
if ($result = $con->query($sql)) {
    /* fetch object array */
    while ($row = $result->fetch_row()) {
 //  printf ("%s %s %s %s <br >", $row[0], $row[1], $row[2],$row[3]);

# Data for the chart
$data0[] = $row[0];
$data1[] = $row[1];
$data2[] = $row[2];
$data3[] = $row[4];
# Labels for the chart
$labels[] = $row[3];
     }
    /* free result set */
    $result->close();
}
/* close connection */
$con->close();
# Create a XYChart object of size 600 x 360 pixels. Use a vertical gradient color from sky blue
# (aaccff) to white (ffffff) as background. Set border to grey (888888). Use rounded corners. Enable
# soft drop shadow.
$c = new XYChart(600, 360);
//$textBoxObj = $c->addTitle("Ambient data trend curve at Bera", "timesbi.ttf", 12);

$c->setBackground($c->linearGradientColor(0, 0, 0, $c->getHeight(), 0xaaccff, 0xffffff), 0x888888);
$c->setRoundedFrame();
$c->setDropShadow();

# Add a title box to the chart using 15pt Arial Bold Italic font. Set top margin to 16 pixels.
$title = $c->addTitle("Ambient Data at Bera", "arialbi.ttf", 15);
$title->setMargin2(0, 0, 16, 0);

# Set the plotarea at (100, 80) and of size 400 x 230 pixels, with white (ffffff) background. Use
# grey #(aaaaa) dotted lines for both horizontal and vertical grid lines.
$c->setPlotArea(100, 80, 400, 230, 0xffffff, -1, -1, $c->dashLineColor(0xaaaaaa, DotLine), -1);

# Add a legend box with the bottom center anchored at (300, 80) (top center of the plot area). Use
# horizontal layout, and 8 points Arial Bold font. Set background and border to transparent.
$legendBox = $c->addLegend(300, 80, false, "arialbd.ttf", 8);
$legendBox->setAlignment(BottomCenter);
$legendBox->setBackground(Transparent, Transparent);

# Set the labels on the x axis.
$c->xAxis->setLabels($labels);

# Display 1 out of 3 labels on the x-axis.
$c->xAxis->setLabelStep(3);

# Add a title to the x-axis
$c->xAxis->setTitle("Hour of Day");

# Add a title on top of the primary (left) y axis.
$textBoxObj = $c->yAxis->setTitle("Amb.\nTemp");
$textBoxObj->setAlignment(TopLeft2);
# Set the axis, label and title colors for the primary y axis to red (c00000) to match the first
# data set
$c->yAxis->setColors(0xcc0000, 0xcc0000, 0xcc0000);

# Add a title on top of the secondary (right) y axis.
$textBoxObj = $c->yAxis2->setTitle("Amb.\nHmdty");
$textBoxObj->setAlignment(TopRight2);
# Set the axis, label and title colors for the secondary y axis to green (00800000) to match the
# second data set
$c->yAxis2->setColors(0x008000, 0x008000, 0x008000);

# Add the third y-axis at 50 pixels to the left of the plot area
$leftAxis = $c->addAxis(Left, 50);
# Add a title on top of the third y axis.
$textBoxObj = $leftAxis->setTitle("Smoke\n(ppm)");
$textBoxObj->setAlignment(TopLeft2);
# Set the axis, label and title colors for the third y axis to blue (0000cc) to match the third data
# set
$leftAxis->setColors(0x0000cc, 0x0000cc, 0x0000cc);

# Add the fouth y-axis at 50 pixels to the right of the plot area
$rightAxis = $c->addAxis(Right, 50);
# Add a title on top of the fourth y axis.
$textBoxObj = $rightAxis->setTitle("O_brd\ntemp");
$textBoxObj->setAlignment(TopRight2);
# Set the axis, label and title colors for the fourth y axis to purple (880088) to match the fourth
# data set
$rightAxis->setColors(0x880088, 0x880088, 0x880088);

# Add a line layer to for the first data set using red (c00000) color, with a line width of 2 pixels
$layer0 = $c->addLineLayer($data0, 0xcc0000, "Temp");
$layer0->setLineWidth(2);

# Add a line layer to for the second data set using green (00c0000) color, with a line width of 2
# pixels. Bind the layer to the secondary y-axis.
$layer1 = $c->addLineLayer($data1, 0x008000, "Hmdty");
$layer1->setLineWidth(2);
$layer1->setUseYAxis2();

# Add a line layer to for the third data set using blue (0000cc) color, with a line width of 2
# pixels. Bind the layer to the third y-axis.
$layer2 = $c->addLineLayer($data2, 0x0000cc, "Smoke");
$layer2->setLineWidth(2);
$layer2->setUseYAxis($leftAxis);

# Add a line layer to for the fourth data set using purple (880088) color, with a line width of 2
# pixels. Bind the layer to the fourth y-axis.
$layer3 = $c->addLineLayer($data3, 0x880088, "O_Brd Temp");
$layer3->setLineWidth(2);
$layer3->setUseYAxis($rightAxis);

# Output the chart
header("Content-type: image/png");
header("Refresh:240");
print($c->makeChart2(PNG));
?>
