//sudo pip install pyttsx
//python text-to-speech.py

#include <NTPClient.h>
#include <Time.h>

#include <Preferences.h>  //For reading and writing into the ROM memory
Preferences preferences;
unsigned int counter;

#include <WiFi.h> //    //For ESP32
#include <WiFiUdp.h>

#include <Adafruit_SSD1306.h>

#include <SPI.h>
#include <Adafruit_GFX.h>
#include <TFT_ILI9163C.h>

#include <DFMiniMp3.h>




class Mp3Notify{
public:
  static void OnError(uint16_t errorCode)  {
    // see DfMp3_Error for code meaning
    Serial.println();
    Serial.print("Com Error ");
    Serial.println(errorCode);
  }

  static void OnPlayFinished(uint16_t globalTrack)  {
    Serial.println();
    Serial.print("Play finished for #");
    Serial.println(globalTrack);   
  }

  static void OnCardOnline(uint16_t code)  {
    Serial.println();
    Serial.print("Card online ");
    Serial.println(code);     
  }

  static void OnCardInserted(uint16_t code)  {
    Serial.println();
    Serial.print("Card inserted ");
    Serial.println(code); 
  }

  static void OnCardRemoved(uint16_t code)  {
    Serial.println();
    Serial.print("Card removed ");
    Serial.println(code);  
  }
};





HardwareSerial Serial2(2); // RX, TX  
DFMiniMp3<HardwareSerial, Mp3Notify> mp3(Serial2);


// Color definitions
#define BLACK   0x0000
#define BLUE    0x001F
#define RED     0xF800
#define GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0  
#define WHITE   0xFFFF

TFT_ILI9163C display = TFT_ILI9163C(2,15,4);  //(CS,A0,RST);

const char *ssid     = "bera1";
const char *password = "**********";

const char *ssid1     = "beramobile"; 
const char *password1 = "**********"; 


uint16_t ccenterx,ccentery;//center x,y of the clock
const uint16_t cradius = 63;//radius of the clock
const float scosConst = 0.0174532925;
float sx = 0, sy = 1, mx = 1, my = 0, hx = -1, hy = 0;
float sdeg=0, mdeg=0, hdeg=0;
uint16_t osx,osy,omx,omy,ohx,ohy;
uint16_t x0 = 0, x1 = 0, yy0 = 0, yy1 = 0;
uint32_t targetTime = 0;// for next 1 second timeout
uint8_t hh,mm,ss;  //containers for current time
char datadate[16];


String dow[7]  = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};  // Sunday is dayOfWeek 0
String moy[12] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"}; // January is month 0

WiFiUDP ntpUDP;
NTPClient timeClient(ntpUDP);
int i=0;

void setup(){
  Serial.begin(115200);
  Serial2.begin(115200);
  mp3.begin();

  uint16_t volume = mp3.getVolume(); //mp3 folder
  Serial.print("volume ");
  Serial.println(volume);
  mp3.setVolume(32); //32 max,24)
  
  uint16_t count = mp3.getTotalTrackCount();
  Serial.print("files ");
  Serial.println(count);
  
  Serial.println("starting...");
  

  
  display.begin();
display.setRotation(0);  //rotation of screen
//  WiFi.begin(ssid, password);
  preferences.begin("my-app", false);
  
//preferences.putUInt("counter", 2);  //write something in the memory to start
counter = preferences.getUInt("counter", 0);
Serial.printf("Current counter value: %u\n", counter);

display.setTextSize(1);
display.setTextColor(WHITE);
display.setCursor(0,0);
display.print("Connecting...");
display.println(counter);

if(counter==1)   WiFi.begin(ssid, password);
if(counter==2)   WiFi.begin(ssid1, password1);

 while ( WiFi.status() != WL_CONNECTED ) {
    delay ( 500 );
    i=i+1;
    Serial.print ( i );
    if(i>40){ 
if(counter==1)   preferences.putUInt("counter", 2);
if(counter==2)   preferences.putUInt("counter", 1);
preferences.end();    
esp_restart();     //Restart ESP it does not get connected for long
//ESP.deepSleep(1*1000000,WAKE_RF_DEFAULT);  //ESP8266 wakes up after 1 seceond sleep;
    }

 
    
     }
  timeClient.begin();
  display.clearScreen();

  
  ccenterx = display.width()/2;
  ccentery = display.height()/2+10;
  osx = ccenterx;
  osy = ccentery;
  omx = ccenterx;
  omy = ccentery;
  ohx = ccenterx;
  ohy = ccentery;
  drawClockFace();// Draw clock face
printDigits(12);
}

void loop() {
  timeClient.update();
String st1=timeClient.getFormattedTime();
Serial.print("Time string value:");
Serial.println(st1);

setTime(timeClient.getEpochTime()+5.5*3600);  //Add 5 hrs 30 minutes to IST
time_t t = now(); //Set the time;


  //get current time from compiler
//  hh = conv2d(__TIME__);
 // mm = conv2d(__TIME__+3);
 // ss = conv2d(__TIME__+6);
  targetTime = millis() + 1000; 

Serial.println(timeClient.getFormattedTime());
Serial.println(st1);
Serial.println(timeClient.getEpochTime()+5.5*3600);
Serial.println(weekday(t));
Serial.print(hour(t));
Serial.print(":");
Serial.print(minute(t));
Serial.print(":");
Serial.println(second(t));
Serial.print(day(t));
Serial.print(month(t));
Serial.println(year(t)-2000);


//display.clearScreen();
display.setTextSize(3);
display.setTextColor(GREEN,BLACK);
display.setCursor(0,0);

printDigits(hour(t));
display.print(":");
printDigits(minute(t));
display.setTextSize(2);
display.setTextColor(CYAN,BLACK);
display.setCursor(95,0);
printDigits(second(t));
display.println();
display.setTextColor(MAGENTA,BLACK);
display.setCursor(92,15);
display.println(dow[weekday(t)-1]);

sprintf(datadate, "%d/%d/%d", day(t),month(t),year(t)-2000);
display.setCursor(display.width()/2-23,display.height()/2-10);
display.setTextSize(0.5); //2
display.setTextColor(WHITE,BLACK);
display.print(datadate);

drawClockHands(hour(t),minute(t),second(t));

if(second(t)==0){
talk(hour(t), minute(t),weekday(t)-1 , day(t), month(t));
delay(1000);
}


}


void talk (int h, int m, int d, int dd, int mm) {
if(h>=0 and h<12){  //AM Loop

mp3.playMp3FolderTrack(110);  // Starting sound
delay(4000);

  
mp3.playMp3FolderTrack(101);  // The time is now
delay(1500);

mp3.playMp3FolderTrack(d+60);  // Day of week
delay(1000);

if (dd<=10) dd= dd+60;
mp3.playMp3FolderTrack(dd);  // Date
delay(1000);

mp3.playMp3FolderTrack(mm+70);  // Month
delay(1500);

if(h==0) {
mp3.playMp3FolderTrack(104);  // Hour
delay(850);
mp3.playMp3FolderTrack(104);  // Hour  
}

mp3.playMp3FolderTrack(h);  // Hour
delay(1000);

if(m>0 and m<10){
mp3.playMp3FolderTrack(104);  // Zero 
delay(900);
}

if(m!=0){
mp3.playMp3FolderTrack(m);  // Minute
delay(1000);
}
mp3.playMp3FolderTrack(102);  // AM
delay(1000);  
}

else {  //PM Loop
if (h>12 and h<=23) h=h-12;

mp3.playMp3FolderTrack(113);  // Starting sound
delay(4000);

mp3.playMp3FolderTrack(101);  // Time is now
delay(1500);
mp3.playMp3FolderTrack(d+60);  // Day
delay(1000);

if (dd<=10) dd= dd+60;
mp3.playMp3FolderTrack(dd);  // Date
delay(1000);

mp3.playMp3FolderTrack(mm+70);  // Month
delay(1500);

mp3.playMp3FolderTrack(h);  // Hour
delay(1000);

if(m>0 and m<10){
mp3.playMp3FolderTrack(104);  // Zero 
delay(900);
}

if(m!=0) {
mp3.playMp3FolderTrack(m);  // minute
delay(1000);
}

mp3.playMp3FolderTrack(103);  // PM
delay(1000);  
  
}




}




void printDigits(int digits){
  if(digits < 10)
    display.print('0');
  display.print(digits);
}


void drawClockFace(){
//  cradius = cradius - 20;
  display.fillCircle(ccenterx, ccentery, cradius-10, BLUE);  //blue
  display.fillCircle(ccenterx, ccentery, cradius-4-10, BLACK); //black
  // Draw 12 lines
  for(int i = 0; i<360; i+= 30) {
    sx = cos((i-90)*scosConst);
    sy = sin((i-90)*scosConst);
    x0 = sx*(cradius-4-10)+ccenterx;
    yy0 = sy*(cradius-4-10)+ccentery;
    x1 = sx*(cradius-11-10)+ccenterx;
    yy1 = sy*(cradius-11-10)+ccentery;
    display.drawLine(x0, yy0, x1, yy1, CYAN);  //blue
  }
}

static uint8_t conv2d(const char* p) {
  uint8_t v = 0;
  if ('0' <= *p && *p <= '9') v = *p - '0';
  return 10 * v + *++p - '0';
}


void drawClockHands(uint8_t h,uint8_t m,uint8_t s){
  // Pre-compute hand degrees, x & y coords for a fast screen update
  sdeg = s * 6;                  // 0-59 -> 0-354
  mdeg = m * 6 + sdeg * 0.01666667;  // 0-59 -> 0-360 - includes seconds
  hdeg = h * 30 + mdeg * 0.0833333;  // 0-11 -> 0-360 - includes minutes and seconds
  hx = cos((hdeg-90)*scosConst);    
  hy = sin((hdeg-90)*scosConst);
  mx = cos((mdeg-90)*scosConst);    
  my = sin((mdeg-90)*scosConst);
  sx = cos((sdeg-90)*scosConst);    
  sy = sin((sdeg-90)*scosConst);

  // Erase just old hand positions
  display.drawLine(ohx, ohy, ccenterx+1, ccentery+1, BLACK);  
  display.drawLine(omx, omy, ccenterx+1, ccentery+1, BLACK);  
  display.drawLine(osx, osy, ccenterx+1, ccentery+1, BLACK);
  // Draw new hand positions  
  display.drawLine(hx*(cradius-28)+ccenterx+1, hy*(cradius-28)+ccentery+1, ccenterx+1, ccentery+1, GREEN);  //white
  display.drawLine(mx*(cradius-17)+ccenterx+1, my*(cradius-17)+ccentery+1, ccenterx+1, ccentery+1, WHITE);
  display.drawLine(sx*(cradius-14)+ccenterx+1, sy*(cradius-14)+ccentery+1, ccenterx+1, ccentery+1, RED);
  display.fillCircle(ccenterx+1, ccentery+1, 3, RED);

  // Update old x&y coords
  osx = sx*(cradius-14)+ccenterx+1;
  osy = sy*(cradius-14)+ccentery+1;
  omx = mx*(cradius-17)+ccenterx+1;
  omy = my*(cradius-17)+ccentery+1;
  ohx = hx*(cradius-28)+ccenterx+1;
  ohy = hy*(cradius-28)+ccentery+1;
}


