//sudo pip install gTTS
//sudo pip install pyttsx
//python text-to-speech.py
/*
from gtts import gTTS
import os
tts = gTTS(text='Good morning', lang='en')
tts.save("good.mp3")
os.system("mpg321 good.mp3")
*/

//Command line code 
//gtts-cli.py “Hello” -l ‘en’ -o hello.mp3

/*
 DS3231
------
Vcc = 3.3 Volt
Gnd = Gnd
SDA = D21
SCL = D22

MP3 Shield


BLACK       0x0000      
NAVY        0x000F      
DARKGREEN   0x03E0      
DARKCYAN    0x03EF      
MAROON      0x7800      
PURPLE      0x780F      
OLIVE       0x7BE0      
LIGHTGREY   0xC618     
DARKGREY    0x7BEF      
BLUE        0x001F      
GREEN       0x07E0     
CYAN        0x07FF     
RED         0xF800     
MAGENTA     0xF81F      
YELLOW      0xFFE0      
WHITE       0xFFFF     
ORANGE      0xFD20      
GREENYELLOW 0xAFE5      
PINK        0xF81F
*/


#include <Time.h>
#include <Adafruit_SSD1306.h>
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <TFT_ILI9163C.h>
#include <DFMiniMp3.h>
#include <Wire.h> // must be included here so that Arduino library object file references work
#include <RtcDS3231.h>

RtcDS3231<TwoWire> Rtc(Wire);
#define countof(a) (sizeof(a) / sizeof(a[0]))


class Mp3Notify{
public:
  static void OnError(uint16_t errorCode)  {
    // see DfMp3_Error for code meaning
    Serial.println();
    Serial.print("Com Error ");
    Serial.println(errorCode);
  }

  static void OnPlayFinished(uint16_t globalTrack)  {
    Serial.println();
    Serial.print("Play finished for #");
    Serial.println(globalTrack);   
  }

  static void OnCardOnline(uint16_t code)  {
    Serial.println();
    Serial.print("Card online ");
    Serial.println(code);     
  }

  static void OnCardInserted(uint16_t code)  {
    Serial.println();
    Serial.print("Card inserted ");
    Serial.println(code); 
  }

  static void OnCardRemoved(uint16_t code)  {
    Serial.println();
    Serial.print("Card removed ");
    Serial.println(code);  
  }
};

HardwareSerial Serial2(2); // RX, TX  
DFMiniMp3<HardwareSerial, Mp3Notify> mp3(Serial2);

// Color definitions
#define BLACK   0x0000
#define BLUE    0x001F
#define RED     0xF800
#define GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0  
#define WHITE   0xFFFF

TFT_ILI9163C display = TFT_ILI9163C(2,4,15);  //(CS,A0,RST);

uint16_t ccenterx,ccentery;//center x,y of the clock
const uint16_t cradius = 63;//radius of the clock
const float scosConst = 0.0174532925;
float sx = 0, sy = 1, mx = 1, my = 0, hx = -1, hy = 0;
float sdeg=0, mdeg=0, hdeg=0;
uint16_t osx,osy,omx,omy,ohx,ohy;
uint16_t x0 = 0, x1 = 0, yy0 = 0, yy1 = 0;
uint32_t targetTime = 0;// for next 1 second timeout
uint8_t hh,mm,ss;  //containers for current time
char datadate[16];


String dow[7]  = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};  // Sunday is dayOfWeek 0
String moy[12] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"}; // January is month 0


int i=0;

void setup(){
  Serial.begin(115200);
  Serial2.begin(115200);
  mp3.begin();

  uint16_t volume = mp3.getVolume(); //mp3 folder
  Serial.print("volume ");
  Serial.println(volume);
  mp3.setVolume(32); //30 max
  
  uint16_t count = mp3.getTotalTrackCount();
  Serial.print("files ");
  Serial.println(count);
  
  Serial.println("starting...");
  

  
  display.begin();
display.setRotation(0);  //rotation of screen
//  WiFi.begin(ssid, password);

display.setTextSize(1);
display.setTextColor(WHITE);
display.setCursor(0,0);


display.clearScreen();

  
  ccenterx = display.width()/2;
  ccentery = display.height()/2+10;
  osx = ccenterx;
  osy = ccentery;
  omx = ccenterx;
  omy = ccentery;
  ohx = ccenterx;
  ohy = ccentery;
  drawClockFace();// Draw clock face
printDigits(12);


//--------RTC SETUP ------------
// if you are using ESP-01 then uncomment the line below to reset the pins to
// the available pins for SDA, SCL
// Wire.begin(0, 2); // due to limited pins, use pin 0 and 2 for SDA, SCL
    
    Rtc.Begin();

    RtcDateTime compiled = RtcDateTime(__DATE__, __TIME__);
//    printDateTime(compiled);
    Serial.println();

    if (!Rtc.IsDateTimeValid())    {
        // Common Cuases:
        //    1) first time you ran and the device wasn't running yet
        //    2) the battery on the device is low or even missing

        Serial.println("RTC lost confidence in the DateTime!");

        // following line sets the RTC to the date & time this sketch was compiled
        // it will also reset the valid flag internally unless the Rtc device is
        // having an issue

        Rtc.SetDateTime(compiled);
    }

    if (!Rtc.GetIsRunning())
    {
        Serial.println("RTC was not actively running, starting now");
        Rtc.SetIsRunning(true);
    }

    RtcDateTime now = Rtc.GetDateTime();
    if (now < compiled)     {
        Serial.println("RTC is older than compile time!  (Updating DateTime)");
        Rtc.SetDateTime(compiled);
    }
    else if (now > compiled)     {
        Serial.println("RTC is newer than compile time. (this is expected)");
    }
    else if (now == compiled)     {
        Serial.println("RTC is the same as compile time! (not expected but all is fine)");
    }

    // never assume the Rtc was last configured by you, so
    // just clear them to your needed state
    Rtc.Enable32kHzPin(false);
    Rtc.SetSquareWavePin(DS3231SquareWavePin_ModeNone); 
}

void loop() {

RtcDateTime t = Rtc.GetDateTime();  
//targetTime = millis() + 1000; 

Serial.println(dow[t.DayOfWeek()]);
Serial.print(t.Hour());
Serial.print(":");
Serial.print(t.Minute());
Serial.print(":");
Serial.println(t.Second());
Serial.print(t.Day());
Serial.print(t.Month());
Serial.println(t.Year()-2000);


//TFT Display
display.setTextSize(3);
display.setTextColor(GREEN,BLACK);
display.setCursor(0,0);

printDigits(t.Hour());
display.print(":");
printDigits(t.Minute());
display.setTextSize(2);
display.setTextColor(CYAN,BLACK);
display.setCursor(95,0);
printDigits(t.Second());
display.println();
display.setTextColor(MAGENTA,BLACK);
display.setCursor(92,15);
display.println(dow[t.DayOfWeek()]);

sprintf(datadate, "%.2d/%.2d/%d", t.Day(),t.Month(),t.Year()-2000);
display.setCursor(display.width()/2-23,display.height()/2-10);
display.setTextSize(0.5); //2
display.setTextColor(0x07FF,BLACK);
display.print(datadate);

RtcTemperature temp = Rtc.GetTemperature();
display.setTextColor(0xFFE0,BLACK);
display.setCursor(display.width()/2-16,display.height()/2);
display.print(temp.AsFloat());
display.print("c");


drawClockHands(t.Hour(),t.Minute(),t.Second());
if(second(t)==0  and (minute(t)==0 or minute(t)==15 or minute(t)==45 or minute(t)==30)  ){
talk(t.Hour(), t.Minute(),t.DayOfWeek() , t.Day(), t.Month());
delay(1000);
temp_talk(temp.AsFloat());
}


}

void temp_talk(float temp1){
  
temp1 = temp1*100;
int f1 = temp1/100;
int f2 = temp1-(f1*100);
int f3 = f2/10;
int f4 = f2%10;


mp3.playMp3FolderTrack(114);  // And the temperature is
delay(2000);

mp3.playMp3FolderTrack(f1);  // 23
delay(1000);

mp3.playMp3FolderTrack(115);  // Point
delay(1000);

if(f3==0) {
mp3.playMp3FolderTrack(104);  // Zero 
delay(900);
}
else {
mp3.playMp3FolderTrack(f3);  // .05
delay(1000); 
}


if(f4>0) {
mp3.playMp3FolderTrack(f4);  // .05
delay(1000); 
}

mp3.playMp3FolderTrack(116);  // Degree Celcius
delay(1000);

}




void talk (int h, int m, int d, int dd, int mm) {
  
if(h>=0 and h<12){  //AM Loop

mp3.playMp3FolderTrack(110);  // Starting sound
delay(4000);

  
mp3.playMp3FolderTrack(101);  // The time is now
delay(1500);

mp3.playMp3FolderTrack(d+60);  // Day of week
delay(1000);

if (dd<=10) dd= dd+90;
mp3.playMp3FolderTrack(dd);  // Date
delay(1000);

mp3.playMp3FolderTrack(mm+70);  // Month
delay(1500);

if(h==0) {
mp3.playMp3FolderTrack(104);  // Hour
delay(850);
mp3.playMp3FolderTrack(104);  // Hour  
}

mp3.playMp3FolderTrack(h);  // Hour
delay(1000);

if(m>0 and m<10){
mp3.playMp3FolderTrack(104);  // Zero 
delay(900);
}

if(m!=0){
mp3.playMp3FolderTrack(m);  // Minute
delay(1000);
}
mp3.playMp3FolderTrack(102);  // AM
delay(1000);  
}

else {  //PM Loop
if (h>12 and h<=23) h=h-12;

mp3.playMp3FolderTrack(113);  // Starting sound
delay(4000);

mp3.playMp3FolderTrack(101);  // Time is now
delay(1500);
mp3.playMp3FolderTrack(d+60);  // Day
delay(1000);

if (dd<=10) dd= dd+90;
mp3.playMp3FolderTrack(dd);  // Date
delay(1000);

mp3.playMp3FolderTrack(mm+70);  // Month
delay(1500);

mp3.playMp3FolderTrack(h);  // Hour
delay(1000);

if(m>0 and m<10){
mp3.playMp3FolderTrack(104);  // Zero 
delay(900);
}

if(m!=0) {
mp3.playMp3FolderTrack(m);  // minute
delay(1000);
}

mp3.playMp3FolderTrack(103);  // PM
delay(1000);  
  
}

}


void printDigits(int digits){
  if(digits < 10)
    display.print('0');
  display.print(digits);
}


void drawClockFace(){
//  cradius = cradius - 20;
  display.fillCircle(ccenterx, ccentery, cradius-10, BLUE);  //blue
  display.fillCircle(ccenterx, ccentery, cradius-4-10, BLACK); //black
  // Draw 12 lines
  for(int i = 0; i<360; i+= 30) {
    sx = cos((i-90)*scosConst);
    sy = sin((i-90)*scosConst);
    x0 = sx*(cradius-4-10)+ccenterx;
    yy0 = sy*(cradius-4-10)+ccentery;
    x1 = sx*(cradius-11-10)+ccenterx;
    yy1 = sy*(cradius-11-10)+ccentery;
    display.drawLine(x0, yy0, x1, yy1, CYAN);  //blue
  }
}

static uint8_t conv2d(const char* p) {
  uint8_t v = 0;
  if ('0' <= *p && *p <= '9') v = *p - '0';
  return 10 * v + *++p - '0';
}


void drawClockHands(uint8_t h,uint8_t m,uint8_t s){
  // Pre-compute hand degrees, x & y coords for a fast screen update
  sdeg = s * 6;                  // 0-59 -> 0-354
  mdeg = m * 6 + sdeg * 0.01666667;  // 0-59 -> 0-360 - includes seconds
  hdeg = h * 30 + mdeg * 0.0833333;  // 0-11 -> 0-360 - includes minutes and seconds
  hx = cos((hdeg-90)*scosConst);    
  hy = sin((hdeg-90)*scosConst);
  mx = cos((mdeg-90)*scosConst);    
  my = sin((mdeg-90)*scosConst);
  sx = cos((sdeg-90)*scosConst);    
  sy = sin((sdeg-90)*scosConst);

  // Erase just old hand positions
  display.drawLine(ohx, ohy, ccenterx+1, ccentery+1, BLACK);  
  display.drawLine(omx, omy, ccenterx+1, ccentery+1, BLACK);  
  display.drawLine(osx, osy, ccenterx+1, ccentery+1, BLACK);
  // Draw new hand positions  
  display.drawLine(hx*(cradius-28)+ccenterx+1, hy*(cradius-28)+ccentery+1, ccenterx+1, ccentery+1, GREEN);  //white
  display.drawLine(mx*(cradius-17)+ccenterx+1, my*(cradius-17)+ccentery+1, ccenterx+1, ccentery+1, WHITE);
  display.drawLine(sx*(cradius-14)+ccenterx+1, sy*(cradius-14)+ccentery+1, ccenterx+1, ccentery+1, RED);
  display.fillCircle(ccenterx+1, ccentery+1, 3, RED);

  // Update old x&y coords
  osx = sx*(cradius-14)+ccenterx+1;
  osy = sy*(cradius-14)+ccentery+1;
  omx = mx*(cradius-17)+ccenterx+1;
  omy = my*(cradius-17)+ccentery+1;
  ohx = hx*(cradius-28)+ccenterx+1;
  ohy = hy*(cradius-28)+ccentery+1;
}


