

void printDateTime(const RtcDateTime& dt){
char datestring[20];
 RtcTemperature temp = Rtc.GetTemperature();
 Serial.print(temp.AsFloat());
 Serial.println(" C");
    snprintf_P(datestring, 
            countof(datestring),
            PSTR("%02u/%02u/%04u %02u:%02u:%02u:%5.3f"),
            dt.Month(),
            dt.Day(),
            dt.Year(),
            dt.Hour(),
            dt.Minute(),
            dt.Second(),
            temp);
    Serial.print(datestring);
    return datestring;
}


void rtc_setup() {
  Rtc.Begin();
    RtcDateTime compiled = RtcDateTime(__DATE__, __TIME__);
    printDateTime(compiled);
    Serial.println();
    if (!Rtc.IsDateTimeValid()) {
        Serial.println("RTC lost confidence in the DateTime!");
        Rtc.SetDateTime(compiled);
    }

    if (!Rtc.GetIsRunning())    {
        Serial.println("RTC was not actively running,  now");
        Rtc.SetIsRunning(true);   //starting
    }

    RtcDateTime now = Rtc.GetDateTime();
    if (now < compiled)     {
        Serial.println("RTC is older than compile time!  (Updating DateTime)");
        Rtc.SetDateTime(compiled);
    }
    else if (now > compiled)     {
        Serial.println("RTC is newer than compile time. (this is expected)");
    }
    else if (now == compiled)    {
        Serial.println("RTC is the same as compile time! (not expected but all is fine)");
    }
    // never assume the Rtc was last configured by you, so
    // just clear them to your needed state
    Rtc.Enable32kHzPin(false);
    Rtc.SetSquareWavePin(DS3231SquareWavePin_ModeNone); 
}

