#include <Adafruit_GFX.h>
#include <TFT_ILI9163C.h>
#include <Wire.h> 
#include <RtcDS3231.h>
RtcDS3231<TwoWire> Rtc(Wire);
#define countof(a) (sizeof(a) / sizeof(a[0]))
#define n 4  // number of displays

String dataString="";

#include "rtc.h" //Just keep this file in the same directory and compile.

// Color definitions
#define	BLACK   0x0000
#define	BLUE    0x001F
#define	RED     0xF800
#define	GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0  
#define WHITE   0xFFFF

// RST & AO pins can be common
// CS pin has to be different for each display
// Pins D0, D1, D12 cannot be used
TFT_ILI9163C tft1  = TFT_ILI9163C(A1,A0,0);  //(CS,A0,RST); 
TFT_ILI9163C tft2  = TFT_ILI9163C(A2,A0,0);  //(CS,AO,RST);
TFT_ILI9163C tft3  = TFT_ILI9163C(A3,A0,0);  //(CS,AO,RST); 
TFT_ILI9163C tft4  = TFT_ILI9163C(A4,A0,0);  //(CS,AO,RST);
// ... add more display like 
// tft5, tft6, tft7 ... tft12

uint16_t ccenterx,ccentery;//center x,y of the clock
const uint16_t cradius = 63;// 63radius of the clock
const float scosConst = 0.0174532925;

uint16_t osx[n],osy[n],omx[n],omy[n],ohx[n],ohy[n];

//uint8_t h,m,s;
float sx = 0, sy = 1;
uint16_t x0 = 0, x1 = 0, yy0 = 0, yy1 = 0;

float mx = 1, my = 0, hx = -1, hy = 0;
float sdeg=0, mdeg=0, hdeg=0;

int j,k;
int x,y,z;

String dow[7]  = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};  // Sunday is dayOfWeek 0
String moy[12] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"}; // January is month 0
int    mday[13]   = {0,31,28,31,30,31,30,31,31,30,31,30,31};

char chartime[16];
char chardate[16];

void drawClockFace(TFT_ILI9163C t){
  t.setTextColor(WHITE, BLACK);
//  t.fillCircle(ccenterx, ccentery, cradius, BLUE);
//  t.fillCircle(ccenterx, ccentery, cradius-4, BLACK);
  t.fillRect(0,0,128,128, BLUE);
  t.fillRect(4,4,120,120, BLACK);

  
  // Draw 12 lines
  for(int i = 0; i<360; i+= 30) {
    sx = cos((i-90)*scosConst);
    sy = sin((i-90)*scosConst);
    x0 = sx*(cradius-4)+ccenterx;
    yy0 = sy*(cradius-4)+ccentery;
    x1 = sx*(cradius-11)+ccenterx;
    yy1 = sy*(cradius-11)+ccentery;
    t.drawLine(x0, yy0, x1, yy1, BLUE);
  }
}


void setup(void) {
  Serial.begin(115200);
  rtc_setup();

  tft1.begin();
  tft2.begin();
  tft3.begin();
  tft4.begin();
  
  ccenterx = tft1.width()/2;
  ccentery = tft1.height()/2;

  for(int i=0;i<=n;i++) {
  osx[n] = ccenterx;
  osy[n] = ccentery;
  omx[n] = ccenterx;
  omy[n] = ccentery;
  ohx[n] = ccenterx;
  ohy[n] = ccentery;
  }
  drawClockFace(tft1);// Draw clock face for TFT1
  drawClockFace(tft2);// Draw clock face for TFT2
  drawClockFace(tft3);// Draw clock face for TFT3
  drawClockFace(tft4);// Draw clock face for TFT4
// Add for remaining clocks ...
 
  }

void drawClockHands(int h,int  m,int s,TFT_ILI9163C t,int cntry){

// preparation of country specific day-date-time block 
if(y%4==0) mday[1]=29;   //conditions for lipyear;
if(s>59) {
    s=s-60; m++;
       }
if(m>59) {
    m=m-60; h++;
       }
if(h>23) {
    h=h-24; k++;x++;
    if(x>mday[y]) {
      x=x-mday[y];
      y++;
    }
}
if(s<0) {
    s=s+60; m--;
       }
if(m<0) {
    h--;
    m=m+60;
       }
if(h<0) {
    h=h+24; k--;x--;
    if(x==0) {
      x=x+mday[y-1];
      y--;
    }
 }
if(k>6) k=k-7;
if(k<0) k=k+7;
if(y>12) y=y-12;
if(y<0)  y=y+12;

sprintf(chartime, " %02d:%02d:%02d", h,m,s);
sprintf(chardate, " %02d/%02d/%02d", x,y,z-2000);

//Country specific block for country=0   ,For vindhyanagar (India)
  if(cntry==0) {
    t.setTextColor(GREEN, BLACK);
    t.setCursor(5,5); //50,34);
    t.print("Vndchal");
    t.setCursor(105,5); //30,44);
    t.print(dow[k]);
    t.setCursor(45,44);
    t.setTextColor(GREEN, BLACK);
    t.print(chartime);
    t.setCursor(45,54);
    t.print(chardate);
   
   }

//Country specific block for country=1   ,For Canbera
  if(cntry==1) {
    t.setTextColor(YELLOW, BLACK);
    t.setCursor(40,34);
    t.print("Canberra");
    t.setCursor(30,44);
    t.print(dow[k]);
    t.setTextColor(YELLOW, BLACK);
    t.print(chartime);
    t.setCursor(40,54);
    t.print(chardate);
    
   }

//Country specific block for country=2   For UK 
  if(cntry==2) {
    t.setTextColor(YELLOW, BLACK);
    t.setCursor(40,34);
    t.print("Britain");
    t.setCursor(30,44);
    t.print(dow[k]);
    t.setTextColor(YELLOW, BLACK);
    t.print(chartime);
    t.setCursor(40,54);
    t.print(chardate);
   }

//Country specific block for country=3  For California
  if(cntry==3) {
    t.setTextColor(YELLOW, BLACK);
    t.setCursor(5,5); //50,34);
    t.print("Calfnia");
    t.setCursor(105,5); //30,44);
    t.print(dow[k]);
    t.setTextColor(YELLOW, BLACK);
    t.setCursor(37,44);
    t.print(chartime);
    t.setCursor(37,54);
    t.print(chardate);
   }




  // Pre-compute hand degrees, x & y coords for a fast screen update
  sdeg = s * 6;                        // 0-59 -> 0-354
  mdeg = m * 6 + sdeg * 0.01666667;   // 0-59 -> 0-360 - includes seconds
  hdeg = h * 30 + mdeg * 0.0833333;  // 0-11 -> 0-360 - includes minutes and seconds
  hx = cos((hdeg-90)*scosConst);    
  hy = sin((hdeg-90)*scosConst);
  mx = cos((mdeg-90)*scosConst);    
  my = sin((mdeg-90)*scosConst);
  sx = cos((sdeg-90)*scosConst);    
  sy = sin((sdeg-90)*scosConst);

   
  // Erase just old hand positions
  t.drawLine(ohx[cntry], ohy[cntry], ccenterx+1, ccentery+1, BLACK);  
  t.drawLine(omx[cntry], omy[cntry], ccenterx+1, ccentery+1, BLACK);  
  t.drawLine(osx[cntry], osy[cntry], ccenterx+1, ccentery+1, BLACK);
 
  // Draw new hand positions  
  t.drawLine(hx*(cradius-28)+ccenterx+1, hy*(cradius-28)+ccentery+1, ccenterx+1, ccentery+1, MAGENTA);
  t.drawLine(mx*(cradius-17)+ccenterx+1, my*(cradius-17)+ccentery+1, ccenterx+1, ccentery+1, WHITE);
  t.drawLine(sx*(cradius-14)+ccenterx+1, sy*(cradius-14)+ccentery+1, ccenterx+1, ccentery+1, RED);
  t.fillCircle(ccenterx+1, ccentery+1, 3, RED);

  // Update old x&y coords
  osx[cntry] = sx*(cradius-14)+ccenterx+1;
  osy[cntry] = sy*(cradius-14)+ccentery+1;
  omx[cntry] = mx*(cradius-17)+ccenterx+1;
  omy[cntry] = my*(cradius-17)+ccentery+1;
  ohx[cntry] = hx*(cradius-28)+ccenterx+1;
  ohy[cntry] = hy*(cradius-28)+ccentery+1;
}


void loop() {
RtcDateTime t = Rtc.GetDateTime();  
k = t.DayOfWeek();

x = t.Day();
y = t.Month();
z = t.Year();

// Temperature of DS3231 chip is calculated but not used.
RtcTemperature tmp = Rtc.GetTemperature();
float tmp1 = tmp.AsFloat();

drawClockHands(t.Hour(),t.Minute(),t.Second(),tft1,0); //Vindhyanagar (India) time
drawClockHands(t.Hour()-12,t.Minute()-30,t.Second(),tft2,3); // California time lags 12 hours 30 minutes
drawClockHands(t.Hour()+4,t.Minute()+30,t.Second(),tft3,1);  // Canbera time leads 4 hours 30 minutes
drawClockHands(t.Hour()-5,t.Minute()-30,t.Second(),tft4,2); // UK time lags 5 hours 30 minutes
// add up the remaining clocks
}




