//************libraries**************//
#include <Wire.h>
#include <RTClib.h>
#include <LiquidCrystal_I2C.h>
#include <TEA5767Radio.h> 
//#include <TEA5767.h>         

//************************************//
LiquidCrystal_I2C lcd(0x3f,20,4); // Display  I2C 20 x 4
RTC_DS1307 RTC;
//#define RTC_DS1307 RTC_I2C_ADDRESS 0x68;
//#define TEA5767Radio_I2C_ADDRESS 0x60;
TEA5767Radio radio = TEA5767Radio();    
//************Button*****************//
int P1=6; // Button SET MENU'
int P2=7; // Button +
int P3=8; // Button -
int P4=9; // SWITCH Alarm
int MEMO = 5; 
int Rswitch = 11; 
int ROnOff = 12;
//**************Alarm***************//
#define LED 13
#define buzzer 10

//************Variables**************//
int hourupg;
int minupg;
int yearupg;
int monthupg;
int dayupg;
int menu =0;
int setAll =0;
float frequency = 0;                            
int RadioState = 0; // Radio Off                                  

                               
float count = 0;                                   
float memory = 0;
float memory0 = 93.50; //red fm
float memory1 = 98.30;   // radio mirchi
float memory2 = 91.10; // Radio city
float memory3 = 102.00;//FM rainbow
float memory4 = 87.50;// Air TVM DTH
uint8_t alarmHours = 0, alarmMinutes = 0;  // Holds the current alarm time
void setup()
{
  Wire.begin();
  RTC.begin();
  lcd.begin();
  lcd.backlight();
  lcd.clear();

  pinMode(P1,INPUT_PULLUP); // https://www.arduino.cc/en/Tutorial/InputPullupSerial
  pinMode(P2,INPUT_PULLUP);
  pinMode(P3,INPUT_PULLUP);
  pinMode(P4,INPUT_PULLUP);
  pinMode(LED,OUTPUT);
  pinMode(buzzer, OUTPUT); // Set buzzer as an output
  pinMode(Rswitch,INPUT_PULLUP);
  pinMode(ROnOff,OUTPUT);
  pinMode(MEMO,INPUT_PULLUP);
  
  printAllOff();
  frequency = memory0;                       //starting frequency
  radio.setFrequency(frequency);
  lcd.setCursor(0,3);
  lcd.print("RED FM:");
  lcd.setCursor(14, 3);
  lcd.print(frequency);  
  
//  Serial.begin(9600);


  if (! RTC.isrunning()) {
    Serial.println("RTC is NOT running!");
    // Set the date and time at compile time
    RTC.adjust(DateTime(__DATE__, __TIME__));
  }
  // RTC.adjust(DateTime(__DATE__, __TIME__)); //removing "//" to adjust the time
    // The default display shows the date and time
  int menu=0;
}
void loop()
{ 

// check if you press the SET button and increase the menu index
  if(digitalRead(P1)== LOW) 
  {
   menu=menu+1;
  }
  if((digitalRead(P2)== LOW)&&(digitalRead(P3)== LOW))                                                                                                                                                                     
  {
    
    DisplaySetHourAll();
    DisplaySetMinuteAll();
    lcd.clear();
    lcd.setCursor(5,0);
    lcd.print("ALARM");
    lcd.setCursor(5,1);
    lcd.print(alarmHours, DEC);
    lcd.print(":");
    lcd.print(alarmMinutes, DEC);
    delay(1000);
    lcd.clear();

  }
// in which subroutine should we go?
  if (menu==0)
    {
     DisplayDateTime(); // void DisplayDateTime
     Alarm(); // Alarm control

  if (digitalRead (Rswitch) == LOW)
  {
   RadioState = RadioState +1; 
  }
  if (RadioState == 0)
  {
   digitalWrite ( ROnOff , LOW); // Radio Off
    
    PrintRadioOff();
   delay(50);
  }
  if (RadioState == 1)
  {
   digitalWrite ( ROnOff , HIGH); // Radio On
  
   Radio();
   delay(50);
  }
  if (RadioState == 3)
  {
   RadioState = 0;
   delay(50);
  }
  }   
    
          
  if (menu==1)
    {
    DisplaySetHour();
    }
  if (menu==2)
    {
    DisplaySetMinute();
    }
  if (menu==3)
    {
    DisplaySetYear();
    }
  if (menu==4)
    {
    DisplaySetMonth();
    }
  if (menu==5)
    {
    DisplaySetDay();
    }
  if (menu==6)
    {
    StoreAgg(); 
    delay(500);
    menu=0;
    frequencyUpdate();
    }
    delay(20);
}

void DisplayDateTime ()
{
// We show the current date and time
  DateTime now = RTC.now();

  lcd.setCursor(0, 1);
  lcd.print("Hour : ");
  
  if (now.hour()<=9)
  {
    lcd.print("0");
  }
  lcd.print(now.hour(), DEC);
  hourupg=now.hour();
  lcd.print(":");
  if (now.minute()<=9)
  {
    lcd.print("0");
  }
  lcd.print(now.minute(), DEC);
  minupg=now.minute();
  lcd.print(":");
  if (now.second()<=9)
  {
    lcd.print("0");
  }
  lcd.print(now.second(), DEC);

  
  lcd.setCursor(0, 0);
  lcd.print("Date : ");
  if (now.day()<=9)
  {
    lcd.print("0");
  }
  lcd.print(now.day(), DEC);
  dayupg=now.day();
  lcd.print("/");
  if (now.month()<=9)
  {
    lcd.print("0");
  }
  lcd.print(now.month(), DEC);
  monthupg=now.month();
  lcd.print("/");
  lcd.print(now.year(), DEC);
  yearupg=now.year();
 

}

void DisplaySetHour()
{
// time setting
  lcd.clear();
  DateTime now = RTC.now();
  if(digitalRead(P2)==LOW)
  {
    if(hourupg==23)
    {
      hourupg=0;
    }
    else
    {
      hourupg=hourupg+1;
    }
  }
   if(digitalRead(P3)==LOW)
  {
    if(hourupg==0)
    {
      hourupg=23;
    }
    else
    {
      hourupg=hourupg-1;
    }
  }
  lcd.setCursor(0,0);
  lcd.print("Set time:");
  lcd.setCursor(0,1);
  lcd.print(hourupg,DEC);
  delay(200);
}

void DisplaySetMinute()
{
// Setting the minutes
  lcd.clear();
  if(digitalRead(P2)==LOW)
  {
    if (minupg==59)
    {
      minupg=0;
    }
    else
    {
      minupg=minupg+1;
    }
  }
   if(digitalRead(P3)==LOW)
  {
    if (minupg==0)
    {
      minupg=59;
    }
    else
    {
      minupg=minupg-1;
    }
  }
  lcd.setCursor(0,0);
  lcd.print("Set Minutes:");
  lcd.setCursor(0,1);
  lcd.print(minupg,DEC);
  delay(200);
}
  
void DisplaySetYear()
{
// setting the year
  lcd.clear();
  if(digitalRead(P2)==LOW)
  {    
    yearupg=yearupg+1;
  }
   if(digitalRead(P3)==LOW)
  {
    yearupg=yearupg-1;
  }
  lcd.setCursor(0,0);
  lcd.print("Set Year:");
  lcd.setCursor(0,1);
  lcd.print(yearupg,DEC);
  delay(200);
}

void DisplaySetMonth()
{
// Setting the month
  lcd.clear();
  if(digitalRead(P2)==LOW)
  {
    if (monthupg==12)
    {
      monthupg=1;
    }
    else
    {
      monthupg=monthupg+1;
    }
  }
   if(digitalRead(P3)==LOW)
  {
    if (monthupg==1)
    {
      monthupg=12;
    }
    else
    {
      monthupg=monthupg-1;
    }
  }
  lcd.setCursor(0,0);
  lcd.print("Set Month:");
  lcd.setCursor(0,1);
  lcd.print(monthupg,DEC);
  delay(200);
}

void DisplaySetDay()
{
// Setting the day
  lcd.clear();
  if(digitalRead(P2)==LOW)
  {
    if (dayupg==31)
    {
      dayupg=1;
    }
    else
    {
      dayupg=dayupg+1;
    }
  }
   if(digitalRead(P3)==LOW)
  {
    if (dayupg==1)
    {
      dayupg=31;
    }
    else
    {
      dayupg=dayupg-1;
    }
  }
  lcd.setCursor(0,0);
  lcd.print("Set Day:");
  lcd.setCursor(0,1);
  lcd.print(dayupg,DEC);
  delay(200);
}

void StoreAgg()
{
// Variable saving
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("SAVING IN");
  lcd.setCursor(0,1);
  lcd.print("PROGRESS");
  RTC.adjust(DateTime(yearupg,monthupg,dayupg,hourupg,minupg,0));
  delay(200);
}
void DisplaySetHourAll()// Setting the alarm minutes
{
  while(digitalRead(P1)==HIGH){

  lcd.clear();

  if(digitalRead(P2)==LOW)
  {
    if(alarmHours==23)
    {
      alarmHours=0;
    }
    else
    {
      alarmHours=alarmHours+1;
    }
  }
   if(digitalRead(P3)==LOW)
  {
    if(alarmHours==0)
    {
      alarmHours=23;
    }
    else
    {
      alarmHours=alarmHours-1;
    }
  }
  lcd.setCursor(0,0);
  lcd.print("Set HOUR Alarm:");
  lcd.setCursor(0,1);
  lcd.print(alarmHours,DEC);
  delay(200);
 }
 delay(200);
}

void DisplaySetMinuteAll()// Setting the alarm minutes
 {
  while(digitalRead(P1)==HIGH){ 

  lcd.clear();
  if(digitalRead(P2)==LOW)
  {
    if (alarmMinutes==59)
    {
      alarmMinutes=0;
    }
    else
    {
      alarmMinutes=alarmMinutes+1;
    }
  }
   if(digitalRead(P3)==LOW)
  {
    if (alarmMinutes==0)
    {
      alarmMinutes=59;
    }
    else
    {
      alarmMinutes=alarmMinutes-1;
    }
  }
  lcd.setCursor(0,0);
  lcd.print("Set MIN. Alarm:");
  lcd.setCursor(0,1);
  lcd.print(alarmMinutes,DEC);
  delay(200);
 }
 delay(200);
}
void printAllOn(){
   lcd.setCursor(0,2);
  lcd.print("Alarm: ");

  
  
  if (alarmHours <= 9)
  {
    lcd.print("0");
  }
  lcd.print(alarmHours, DEC);
  
  lcd.print(":");
  if (alarmMinutes <= 9)
  {
    lcd.print("0");
  }
  lcd.print(alarmMinutes, DEC); 

}

void printAllOff() {
  lcd.setCursor(0, 2);
  lcd.print("Alarm: Off  ");  
}
void Alarm(){
   if(digitalRead(P4)== LOW)
  {
   setAll=setAll+1;
  }
  if (setAll==0)
    {
     printAllOff();
     noTone (buzzer);
     digitalWrite(LED,LOW);
     }
  if (setAll==1)
    {

     printAllOn();    
  
     DateTime now = RTC.now();
     if ( now.hour() == alarmHours && now.minute() == alarmMinutes )
        {
         RadioState = 0;
         lcd.noBacklight();
         digitalWrite(LED,HIGH);
         tone(buzzer,880,300); //play the note "A5" (LA5)
         delay (100);
         tone(buzzer,698,300); //play the note "F6" (FA6)
         lcd.backlight();
        }
    else{
         noTone (buzzer);
         digitalWrite(LED,LOW);
        }
    
    } 
  if (setAll==2)
    {
     setAll=0;
    }
    delay(20);
}
void Radio(){
if(digitalRead(MEMO)== LOW)
  {
    memory = memory+1;
  }
 
 if (memory == 0)
{
   frequencyUpdate();
  lcd.setCursor(0,3);
   lcd.print("FREQUENCY:    ");
   delay(20);
  if(digitalRead(P2)== LOW)                      
  {
    count=0;
    while (digitalRead(P2)== LOW)
    {
      count++;
      if(count > 0 && count <= 6)          
      {
        frequency += 0.1;
        frequencyUpdate();
        lcd.setCursor(0,3);
         lcd.print("FREQUENCY:    ");
        delay(200);
      }
      else if (count > 6 && count <= 2)   
      {
        frequency += 0.1;
        frequencyUpdate();
        lcd.setCursor(0,3);
        lcd.print("FREQUENCY:     ");
        delay(80);
      }
      else                                
      {
        frequency += 0.1;
        frequencyUpdate();
        lcd.setCursor(0,3);
        lcd.print("FREQUENCY:     ");
        delay(5);
      }
    }
    if (frequency == 108.5)
    {
      frequency = 87.4;
    }

  }
  
  
  
   if(digitalRead(P3)== LOW)                   
   {
     count = 0;
    while (digitalRead(P3)== LOW)            
    {
      count--;
     if(count < 0 && count >= -6)
      {
        frequency -= 0.1;
        frequencyUpdate();
        lcd.setCursor(0,3);
         lcd.print("FREQUENCY:    ");
        delay(200);
      }
      else if (count < -6 && count >= -12)
      {
        frequency -= 0.1;
        frequencyUpdate();
        lcd.setCursor(0,3);
         lcd.print("FREQUENCY:    ");
        delay(80);
      }
      else                                 
      {
        frequency -= 0.1;
        frequencyUpdate();
        lcd.setCursor(0,3);
         lcd.print("FREQUENCY: ");
        delay(5);
      }
    }
    if (frequency == 87.5)
    {
      frequency = 108.5;
    }
   } 
} 
if (memory == 1)
  {
   frequency = memory0; 
  frequencyUpdate();
   lcd.setCursor(0,3);
   lcd.print("RED FM :      ");
   delay(20);
  }
  if (memory == 2)
  {
   frequency = memory1; 
   frequencyUpdate();
   lcd.setCursor(0,3);
   lcd.print("RADIO MIRCHI : ");
   delay(20);
  }
  if (memory == 3)
  {
   frequency = memory2; 
   
   frequencyUpdate();
   lcd.setCursor(0,3);
   lcd.print("RADIO CITY :   ");
   delay(20);
  }
  if (memory == 4)
  {
   frequency = memory3; 
   frequencyUpdate();
   lcd.setCursor(0,3);
   lcd.print("FM RAINBOW :  ");
   delay(20);
   }
   if (memory == 5)
  {
   frequency = memory4; 

   frequencyUpdate();
   lcd.setCursor(0,3);
   lcd.print("AIR DTH :   ");
   delay(20);
  }
   if (memory == 6)
  {
   
  
   memory = 0;
   delay(20);
  }
   

}


void frequencyUpdate()                    //this function changes the frequency of the station, is called by preset and frequency up/down conditions.
{
  frequency = constrain(frequency, 87.5, 108.5);
  
  
  lcd.setCursor(14,3);
  if (frequency < 99.90){
  lcd.print(" ");
    lcd.print(frequency);
  }
  else{

  lcd.print(frequency);
  }
  radio.setFrequency(frequency);
}
void PrintRadioOff()
{
    lcd.setCursor(0,3);
   lcd.print("Radio: Off          ");  
   
}
