#include <MQ135.h>
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <FreeSerif12pt7b.h>
#include <FreeMono9pt7b.h>
#include <FreeMono12pt7b.h>	
#include <FreeMonoOblique9pt7b.h>		
#include <TomThumb.h>
#include <FreeMonoBold12pt7b.h>	
#include <Org_01.h>	
#include <FreeMonoBold9pt7b.h>	
#define OLED_RESET D4
Adafruit_SSD1306 display(OLED_RESET);
/////////////////////////////////////////////////
#include "application.h"
SYSTEM_MODE (AUTOMATIC);
SYSTEM_THREAD (ENABLED);
/////////////////////////////////////////
int number = 0;
int state = 0;
MQ135 gasSensor = MQ135(A4);
float rzero = gasSensor.getRZero();
int ppm = gasSensor.getPPM();
////////////////////////////////////////iputs outputs
int LOUD=A1;
int ledpublish = D7;
int airled=D6;
int loud=D8;
int airin=D4;
////////////////////////////////////////inputs outputs
/////////////////////////////////////sensor value storage
int db=0;
int r1=0;
int r2=0;
float rawnoise = 0.0;
int co2=0;
int air=0;
///////////////////////////////////////sensor value storage
char message[] = "Hello WOrrlllllllllllllll";
int  x, minX;
//////////////////////////////////////////////////////////

const BleUuid serviceUuid("5c1b9a0d-b5be-4a40-8f7a-66b36d0a5176");

BleCharacteristic aqiCharacteristic("aqi", BleCharacteristicProperty::NOTIFY, BleUuid("fdcf4a3f-3fed-4ed2-84e6-04bbb9ae04d4"), serviceUuid);
BleCharacteristic co2SourceCharacteristic("co2", BleCharacteristicProperty::NOTIFY, BleUuid("cc97c20c-5822-4800-ade5-1f661d2133ee"), serviceUuid);
BleCharacteristic noiseCharacteristic("noise", BleCharacteristicProperty::NOTIFY, BleUuid("d2b26bf3-9792-42fc-9e8a-41f6107df04c"), serviceUuid);


///////////////////////////////////////////////////////////////////////////////////////////////////////////////

void setup() {
  Serial.begin(9600); 
  ////////////////////////imputs outputs
  pinMode(LOUD, INPUT);
  pinMode(airin, INPUT);///quality status
  
  pinMode(airled, OUTPUT);///air quality status
  pinMode(ledpublish, OUTPUT);/////publish status
  pinMode(loud, OUTPUT);///loud status
  
  //pip install face_recognition
  // pip install imutils 
  /////////////////////////inputs outputs
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);  
  display.clearDisplay(); 
  display.setTextWrap(false);
  x=display.width();
  minX=-12*strlen(message);
    
    /// ble char setting 
	BLE.addCharacteristic(aqiCharacteristic);
	BLE.addCharacteristic(co2SourceCharacteristic);
	BLE.addCharacteristic(noiseCharacteristic);
    ///for blr 
	BleAdvertisingData advData;
	// Advertise our private service only
	advData.appendServiceUUID(serviceUuid);
    // Continuously advertise when not connected
	BLE.advertise(&advData);

}

void loop() {
    
    display.clearDisplay();
    sensor();
    oleddis();
    bleda();
    delay(800);

}

void sensor(){
    //////////////////////air
    float rzero = gasSensor.getRZero();
    int co2_ppm = gasSensor.getPPM();
    co2=co2_ppm;
    int ppm = co2_ppm / 4;
    air=ppm;
    r1 =map(air,0,1000,0,110);
    ////////////////////air

    ///////////////////sound c
    rawnoise=analogRead(LOUD);
    db = (rawnoise+83.2073) / 11.003;
    r2 =map(db,0,180,0,110);
    ////////////////////sound
    Serial.println("");
    Serial.print ("   co2ppm=");
    Serial.print (co2);
    Serial.print ("ppm");
    Serial.print (" Air ppm=");
    Serial.print (ppm);
    Serial.print (" ppm");
    Serial.print (" sound=");
    Serial.print (db);
    Serial.print (" db");
    
    if (digitalRead(airin)==1){
        
        digitalWrite(airled,HIGH);
        
    }
    else 
     digitalWrite(airled,LOW);
    
     if (db>66)
     {
        
        digitalWrite(loud,HIGH);
        
    }
    else 
        digitalWrite(loud,LOW);

    
    
}

void oleddis(){
     
     display.setFont(NULL);
     display.setTextColor(WHITE);
     display.setTextSize(1);
     display.setCursor(x,5);
     display.print("Co2=");
     display.setFont(&FreeMonoBold9pt7b);
     display.print(co2);
     display.setFont(NULL);
     display.print("ppm--Air qual=");
     display.setFont(&FreeMonoBold9pt7b);
     display.print(air);
     display.setFont(NULL);
     display.print("ppm");
      x=x-13;
     if(x<minX){
         x=display.width();
     
     }
     
     display.setTextSize(1);
     display.setTextColor(WHITE);
     display.setCursor(0,20);
     display.setFont(&FreeMonoBold9pt7b);
     display.print("Co2=");
     display.print(co2);
     display.setFont(NULL);
     display.drawRoundRect(0, 30, 120, 8, 6, WHITE);
     display.fillRoundRect(0, 30, r1, 8, 6, WHITE);
     
     display.setTextSize(1);
     display.setTextColor(WHITE);
     display.setCursor(0,44);
     display.setFont(&FreeMonoBold9pt7b);
     display.print("Noise=");
     display.setFont(&FreeMonoBold9pt7b);
     display.print(db);
     display.print(" Db");
     display.drawRoundRect(0, 54, 120, 8, 6, WHITE);
     display.fillRoundRect(0, 54, r2, 8, 6, WHITE);
     display.display(); 
     
     
}


void bleda(){

   	        uint8_t co2level[1];
			uint8_t aqilevel[1];
			uint8_t noiselevel[1];
			
			co2level[0] = co2 >> 4;
			aqilevel[0] = air >> 4;
			noiselevel[0] = db >> 4;
			
			aqiCharacteristic.setValue(co2level);
		    co2SourceCharacteristic.setValue(aqilevel);
		    noiseCharacteristic.setValue(noiselevel);
   
    Particle.publish("Device 1 Noise",String(db)+"Db -- "+"Co2="+String(co2)+" PPM --- "+ "AQI="+ String(air)+" PPM",21600,PRIVATE);
    Mesh.publish("Noise", String(db));
    Mesh.publish("Aqi", String(air));

     digitalWrite(ledpublish,HIGH);
     delay(100);
     digitalWrite(ledpublish,LOW);
}













