
#include <Arduino.h>
#include <U8g2lib.h>

#include "hx711.h"
Hx711 scale(A1, A0);
float weight=0.0;
#ifdef U8X8_HAVE_HW_SPI
#include <SPI.h>
#endif
#ifdef U8X8_HAVE_HW_I2C
#include <Wire.h>
#endif
U8G2_SSD1306_128X64_NONAME_1_HW_I2C u8g2(U8G2_R0, /* reset=*/ U8X8_PIN_NONE);



void setup(void) {
 Serial.begin(9600);
 u8g2.begin();
u8g2.enableUTF8Print();    
}

void loop(void) {
  weight=scale.getGram();
  
  u8g2.firstPage();
  do {
    u8g2.setFont(u8g2_font_ncenB08_tr);
    u8g2.setCursor(10, 10);
    u8g2.print(F("Weight="));
    u8g2.setFont(u8g2_font_ncenB14_tr);
    u8g2.setCursor(25, 30);
    u8g2.print(weight);
    u8g2.setFont(u8g2_font_ncenB08_tr);
    u8g2.print("  gram");
    u8g2.setFont(u8g2_font_ncenB08_tr);
    u8g2.setCursor(2, 50);
    u8g2.print("Put your object");
    u8g2.setFont(u8g2_font_open_iconic_all_2x_t);
    u8g2.drawGlyph(90, 59, 230); 
  } while ( u8g2.nextPage() );
  delay(100);
}
