/*
  MQUnifiedsensor Library - implementing an alcoholimeter

  Demonstrates the use a MQ3 sensor.
  Library originally added 01 may 2019
  by Miguel A Califa, Yersson Carrillo, Ghiordy Contreras, Mario Rodriguez
 
  Added example
  modified 23 May 2019
  by Miguel Califa 

 This example code is in the public domain.

*/

//Include the library
#include <MQUnifiedsensor.h>
#include <Adafruit_FONA.h>
//Definitions
#define pin A3 //Analog input 0 of your arduino
#define type 3 //MQ3

#define FONA_RX 8
#define FONA_TX 9
#define FONA_RST 4
int doubtpin=11;
int relay=13;
//Declare Sensor

MQUnifiedsensor MQ3(pin, type);
char replybuffer[255];

Adafruit_FONA fona = Adafruit_FONA(FONA_RST);
#include <SoftwareSerial.h>
SoftwareSerial fonaSS = SoftwareSerial(FONA_TX, FONA_RX);
SoftwareSerial *fonaSerial = &fonaSS;



uint8_t readline(char *buff, uint8_t maxbuff, uint16_t timeout = 0);

void setup() {
  Serial.begin(9600);
  pinMode(doubtpin,INPUT);
  pinMode(13,OUTPUT);
  //init the sensor
  /*****************************  MQInicializar****************************************
  Input:  pin, type 
  Output:  
  Remarks: This function create the sensor object.
  ************************************************************************************/ 
  MQ3.inicializar(); 

  float RoCleanAir = MQ3.calibrate();

  Serial.print("R0 preconfigurado: ");
  Serial.println(MQ3.getR0());
  Serial.print("R0 clean air: ");
  Serial.println(RoCleanAir);
  //MQ3.setR0(RoCleanAir);
   fonaSerial->begin(4800);
  if (! fona.begin(*fonaSerial)) {
    Serial.println(F("Couldn't find FONA"));
    while(1);
  }
  Serial.println(F("FONA is OK"));

  // Print SIM card IMEI number.
  char imei[16] = {0}; // MUST use a 16 character buffer for IMEI!
  uint8_t imeiLen = fona.getIMEI(imei);
  if (imeiLen > 0) {
    Serial.print("SIM card IMEI: "); Serial.println(imei);
  }

  fonaSerial->print("AT+CNMI=2,1\r\n");
    Serial.println("FONA Ready");
    char fonaNotificationBuffer[64];          //for notifications from the FONA
char smsBuffer[250];//set up the FONA to send a +CMTI notification when an SMS is received

}

void loop() {
  /*****************************  MQReadSensor  ****************************************
  Input:   Gas - Serial print flag
  Output:  Value in PPM
  Remarks: This function use readPPM to read the value in PPM the gas in the air.
  ************************************************************************************/ 
  //Read the sensor and print in serial port
  //Lecture will be saved in lecture variable
  int lecture =  MQ3.readSensor("", true); // Return Alcohol concentration

  int gL = lecture/1000;
  Serial.print("Alcohol ppm measured: ");
  Serial.print(lecture);
  Serial.println("ppm");

  Serial.print("Alcohol gL measured: ");
  Serial.print(gL);
  Serial.println("g/L");
  if (digitalRead(doubtpin)==HIGH){
    Serial.println("grater");
    digitalWrite(13,HIGH);
     if (!fona.sendSMS("7979952235", "Hey,This  Car Number is driving wile  drunk")) {
        Serial.println(F("Failed"));
      } else {
        Serial.println(F("Sent!"));
        delay(4000);
      }
  }else{
    
  digitalWrite(13,HIGH);
  delay(300);
}}
