#include <Wire.h>
#include <MPU6050.h>
MPU6050 mpu;
////////////////////
#include <U8g2lib.h>
U8G2_SSD1306_128X64_NONAME_F_HW_I2C u8g2(U8G2_R0, /* reset=*/ U8X8_PIN_NONE);
#include "MAX30100_PulseOximeter.h"
PulseOximeter pox;

void onBeatDetected()
{
    Serial.println("Beat!");
    u8g2.setCursor(75, 42);
    u8g2.print("Beat!");
    
}
/////////////////
void setup() 
{
  Serial.begin(115200);
  ///////////////////
  u8g2.begin(); 
  //////////////////
  Serial.println("Initialize MPU6050");

  while(!mpu.begin(MPU6050_SCALE_2000DPS, MPU6050_RANGE_2G))
  {
    Serial.println("Could not find a valid MPU6050 sensor, check wiring!");
    delay(500);
  }
 if (!pox.begin()) {
        Serial.println("FAILED");
        for(;;);
    } else {
        Serial.println("SUCCESS");
    }


    // pox.setIRLedCurrent(MAX30100_LED_CURR_7_6MA);


    pox.setOnBeatDetectedCallback(onBeatDetected);
}

void loop()
{
  // Read normalized values 
  Vector normAccel = mpu.readNormalizeAccel();
  
  // Calculate Pitch & Roll
  int pitch = -(atan2(normAccel.XAxis, sqrt(normAccel.YAxis*normAccel.YAxis + normAccel.ZAxis*normAccel.ZAxis))*180.0)/M_PI;
  int roll = (atan2(normAccel.YAxis, normAccel.ZAxis)*180.0)/M_PI;
  
  pox.update();
  
  u8g2.clearBuffer();
  u8g2.firstPage();
  do {
    u8g2.setFont(u8g2_font_pxplusibmvga9_tf);
    u8g2.setCursor(0, 12);
    u8g2.print("x=");
    u8g2.print(roll);
    u8g2.print(char(176));
    
    u8g2.setCursor(0, 26);
    u8g2.print("y=");
    u8g2.print(pitch);
    u8g2.print(char(176));

    u8g2.setCursor(0, 42);
    u8g2.print("T=");
    u8g2.print(mpu.readTemperature());
    u8g2.print(char(176));
    u8g2.print("c");

    u8g2.drawVLine(64, 4, 25);

    u8g2.setCursor(66, 12);
    u8g2.print("H=");
    u8g2.print(pox.getHeartRate());
    u8g2.print("Bps");

    u8g2.setCursor(66, 27);
    u8g2.print("O2=");
    u8g2.print(pox.getSpO2());
    u8g2.print("%");
    pox.update();
        
    u8g2.drawRFrame(2,47,122,12,6);
    u8g2.drawFilledEllipse( map(pitch, -100, 100, 0, 122), 52, 7, 5, U8G2_DRAW_ALL);
    
    if (pitch==0){
       
       u8g2.setFont(u8g2_font_pxplusibmvga9_tf);
       u8g2.setCursor(59,63);
       u8g2.print("flat");
       
    }
  } 
  while ( u8g2.nextPage() );
    pox.update();
 }
