
#include <Wire.h>
#include "MAX30100_PulseOximeter.h"

#define REPORTING_PERIOD_MS     100
#include <Arduino.h>
#include <OLED_SSD1306_Chart.h>
float val1=0;
float val2=0;
#define SCREEN_WIDTH 128 // OLED display width, in pixels
#define SCREEN_HEIGHT 64 // OLED display height, in pixels

// Declaration for an SSD1306 display connected to I2C (SDA, SCL pins)
#define OLED_RESET     -1 // Reset pin # (or -1 if sharing Arduino reset pin)

OLED_SSD1306_Chart display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

PulseOximeter pox;

uint32_t tsLastReport = 0;

// Callback (registered below) fired when a pulse is detected
void onBeatDetected()
{
    Serial.println("B:1");
      val1=0;
      if(!display.updateChart(val1, val2))   //Value between Ymin and Ymax will be added to chart
    {
      display.clearDisplay();              //If chart is full, it is drawn again
      display.drawChart();
    }
}

void setup()
{
    Serial.begin(115200);

    if (!pox.begin(PULSEOXIMETER_DEBUGGINGMODE_PULSEDETECT)) {
        Serial.println("ERROR: Failed to initialize pulse oximeter");
        for(;;);
    }
     Wire.begin();
   display.begin(SSD1306_SWITCHCAPVCC, 0x3c);
  display.clearDisplay();
  display.setChartCoordinates(0, 60);         //Chart lower left coordinates (X, Y)
  display.setChartWidthAndHeight(123, 60);    //Chart width = 123 and height = 60
  display.setXIncrement(5);                   //Distance between Y points will be 5px
  display.setYLimits(0, 100);                 //Ymin = 0 and Ymax = 100 for first chart
  display.setYLimits(0, 100, 1);              //Ymin = 0 and Ymax = 100 for second chart
  display.setPointGeometry(POINT_GEOMETRY_CIRCLE, 1); //Points will be circles for second chart
  display.setAxisDivisionsInc(12, 6);         //Each 12 px a division will be painted in X axis and each 6px inY axis
  display.setPlotMode(DOUBLE_PLOT_MODE);      //Set double plot mode
  display.drawChart();                        //Update the buffer to draw the cartesian chart 
  display.display();
    // The default current for the IR LED is 50mA and it could be changed
    //   by uncommenting the following line. Check MAX30100_Registers.h for all the
    //   available options.
    // pox.setIRLedCurrent(MAX30100_LED_CURR_7_6MA);

    // Register a callback for the beat detection
    pox.setOnBeatDetectedCallback(onBeatDetected);

    pox.setOnBeatDetectedCallback(onBeatDetected);
}

void loop()
{
    // Make sure to call update as fast as possible
    pox.update();
     val1=pox.getHeartRate();
    val2=pox.getSpO2();
    // Asynchronously dump heart rate and oxidation levels to the serial
    // For both, a value of 0 means "invalid"
    if (millis() - tsLastReport > REPORTING_PERIOD_MS) {
        Serial.print("H:");
        Serial.println(pox.getHeartRate());

        Serial.print("O:");
        Serial.println(pox.getSpO2());

        tsLastReport = millis();
    }
      if(!display.updateChart(val1, val2))   //Value between Ymin and Ymax will be added to chart
      {
        display.clearDisplay();              //If chart is full, it is drawn again
        display.drawChart();
      }
}
