import cv2

from Bluetin_Echo import Echo
import time
from espeak import espeak

video_capture = cv2.VideoCapture(0)

TRIGGER_PIN = 27
ECHO_PIN = 22

speed_of_sound = 315
echo = Echo(TRIGGER_PIN, ECHO_PIN, speed_of_sound)

while True:
    # Grab a single frame of video
    result = (round(echo.read(),4))
    distance=(str(result)+"cm")
    ret, frame = video_capture.read()
    font = cv2.FONT_HERSHEY_DUPLEX
    cv2.putText(frame,distance, (250, 250), font, 1.0, (40, 155, 155), 2,cv2.LINE_4)
       
    if result < 15.0 :
        print("alert too close")
        espeak.set_voice("f5")
        espeak.synth("Alert Too Close to Obstacle")
        cv2.putText(frame,"alert very close", (220, 200), font, 0.5, (40, 255, 255), 2,cv2.LINE_4)
     
        
    # Display the resulting image
    cv2.imshow('Video', frame)
    print(result, 'cm')
 

    # Hit 'q' on the keyboard to quit!
    if cv2.waitKey(1) & 0xFF == ord('q'):
        break

# Release handle to the webcam
video_capture.release()
cv2.destroyAllWindows()
