from aiy.board import Board,Led
import speech_recognition as sr
import math
import time
import argparse
import time
import threading
from aiy.voice.audio import AudioFormat, play_wav, record_file, Recorder
from aiy.leds import (Leds, Pattern, PrivacyLed, RgbLeds, Color)

#from gpiozero import LED
from gpiozero import LEDBoard

#from aiy.pins import (PIN_A, PIN_B, PIN_C, PIN_D)


led1 = LEDBoard(27)



r = sr.Recognizer()
def main():
    print('LED is ON while button is pressed (Ctrl-C for exit).')
    parser = argparse.ArgumentParser()
    parser.add_argument('--filename', '-f', default='recording.wav') 
    args = parser.parse_args()

    
    with Board() as board:
        while True:
            with Leds() as leds:
                board.button.wait_for_press()
                done = threading.Event()
                board.button.when_pressed = done.set
                with sr.Microphone() as source:
                    r.adjust_for_ambient_noise(source)
                    board.led.state = Led.ON
                    print("Say something!")
                    audio = r.listen(source)
                    leds.update(Leds.rgb_on(Color.GREEN))
                    print("Recognizing Now .... ")
                    command=str(r.recognize_google(audio))
                    print("Google Speech Recognition thinks you said " + command)
                    
                    if (command=="lights off"):
                         print('OFF')
                         led1.off()
                        
                        

                    if(command== "lights on"):
                        leds.update(Leds.rgb_on(Color.GREEN))
                        print("lights on")
                       
                       
                        led1.on()

                        
                    if (command=="record me"):
                         def wait():
                             start = time.monotonic()
                             while not done.is_set():
                                 duration = time.monotonic() - start
                                 print('Recording: %.02f seconds [Press button to stop]' % duration)
                                 time.sleep(0.5)
                         record_file(AudioFormat.CD, filename=args.filename, wait=wait, filetype='wav')
                         print('Press button to play recorded sound.')
                         board.button.wait_for_press()
                         print('Playing...')
                         play_wav(args.filename)
                         print('Done.')
                    
                    
                        


if __name__ == '__main__':
    main()
