from aiy.board import Board, Led
import speech_recognition as sr
r = sr.Recognizer()
def main():
    print('LED is ON while button is pressed (Ctrl-C for exit).')
    with Board() as board:
        while True:
            board.button.wait_for_press()
            with sr.Microphone() as source:
                r.adjust_for_ambient_noise(source)
                board.led.state = Led.ON
                print("Say something!")
                audio = r.listen(source)
                print("Recognizing Now .... ")
                print("Google Speech Recognition thinks you said " + r.recognize_google(audio))
                print('OFF')
                board.led.state = Led.OFF


if __name__ == '__main__':
    main()
