#include <Servo.h>
#include <Wire.h>
#include <MPU6050.h>

MPU6050 mpu;

// Timers
unsigned long timer = 0;
float timeStep = 0.01;

Servo Armjoint1;
Servo Armjoint2;
Servo Armjoint3;

int posjoint1;
int posjoint2;
int posjoint3;

int pitch = 0;
int roll = 0;
int yaw = 0;

void setup() {
   Armjoint1.attach(5);
   Armjoint2.attach(6);
   Armjoint3.attach(9);
 
  // Initialize MPU6050
  while(!mpu.begin(MPU6050_SCALE_2000DPS, MPU6050_RANGE_2G))
  {
    Serial.println("Could not find a valid MPU6050 sensor, check wiring!");
    delay(500);
  }
  mpu.calibrateGyro();

  // Set threshold sensivty. Default 3.
  // If you don't want use threshold, comment this line or set 0.
  mpu.setThreshold(3);
}

void loop() {
   timer = millis();
   Vector norm = mpu.readNormalizeGyro();
 
  // Calculate Pitch, Roll and Yaw
  pitch = pitch + norm.YAxis * timeStep;
  roll = roll + norm.XAxis * timeStep;
  yaw = yaw + norm.ZAxis * timeStep;

  delay((timeStep*10) - (millis() - timer));

  posjoint1= map(pitch, 0, 360, 0, 180);
  posjoint2=map(roll, 0, 360, 0, 180);
  posjoint3=map(yaw, 0, 360, 0, 180);
 
  Armjoint1.write(posjoint1);
  Armjoint2.write(posjoint2);
  Armjoint3.write(posjoint3);
  delay(15);  
}
