// EmonLibrary examples openenergymonitor.org, Licence GNU GPL V3

#include "EmonLib.h"                   // Include Emon Library
EnergyMonitor emon1;                   // Create an instance

#include <U8g2lib.h>
#include <Wire.h>
U8G2_SSD1306_128X64_NONAME_F_HW_I2C u8g2(U8G2_R0, /* reset=*/ U8X8_PIN_NONE);

        
void setup()
{  
  Serial.begin(9600);
  u8g2.begin();

// u8g2.setFont(u8g2_font_profont11_tf);//967
u8g2.setFont(u8g2_font_profont17_tr);//980
//
  emon1.current(1, 111.1);             // Current: input pin, calibration.
}

void loop()
{
  double Irms = emon1.calcIrms(1480);  // Calculate Irms only
  
  Serial.print(Irms*230.0);	       // Apparent power
  Serial.print(" ");
  Serial.println(Irms);		
  
u8g2.clearBuffer();
u8g2.setCursor(5,10);
u8g2.print("App power=");
u8g2.setCursor(5,25);
u8g2.print(Irms*230.0);
u8g2.print(" Current");
u8g2.setCursor(5,40);
u8g2.print(Irms);
u8g2.print(" A");
u8g2.drawRFrame(2,47,122,8,3);
u8g2.drawRBox(2, 47,(map(Irms, 0, 5, 0, 122)),8,3);
u8g2.sendBuffer();// Irms
}
