#include <IrSenderPwm.h>

static const frequency_t necFrequency = 38400U;
static const unsigned long BAUD = 115200U;
static const pin_t PIN = 9U;

// NEC(1) 122 29 with no repetition; powers on many Yamaha receivers
static const microseconds_t array0[] = {
417U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 65535U 
};
// NEC(1) 122 29 with no repetition; powers on many Yamaha receivers
static const microseconds_t array1[] = {
 417U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 444U, 167U, 65535U 
 };

static const microseconds_t array2[] = {
417U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 65535U 
};
// NEC(1) 122 29 with no repetition; powers on many Yamaha receivers
static const microseconds_t array3[] = {
417U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 778U, 167U, 65535U 
};
// NEC(1) 122 29 with no repetition; powers on many Yamaha receivers
static const microseconds_t array4[] = {
417U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 444U, 167U, 444U, 167U, 778U, 167U, 278U, 167U, 65535U
};
// NEC(1) 122 29 with no repetition; powers on many Yamaha receivers
static const microseconds_t array5[] = {
 417U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 444U, 167U, 444U, 167U, 778U, 167U, 278U, 167U, 65535U 
 };
// NEC(1) 122 29 with no repetition; powers on many Yamaha receivers
static const microseconds_t array6[] = {
417U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 444U, 167U, 444U, 167U, 65535U 
};
// NEC(1) 122 29 with no repetition; powers on many Yamaha receivers
static const microseconds_t array7[] = {
417U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 444U, 167U, 778U, 167U, 65535U 
};
 // NEC(1) 122 29 with no repetition; powers on many Yamaha receivers
static const microseconds_t array8[] = {
 417U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 278U, 167U, 65535U 
 };

// NEC(1) 122 29 with no repetition; powers on many Yamaha receivers
static const microseconds_t array9[] = {
 417U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 65535U 
 };
// NEC(1) 122 29 with no repetition; powers on many Yamaha receivers
static const microseconds_t arrayU[] = {
  417U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 444U, 167U, 278U, 167U, 278U, 167U, 65535U 
  };

static const microseconds_t arrayD[] = {
   417U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 444U, 167U, 278U, 167U, 444U, 167U, 65535U 
   };

// NEC(1) 122 29 with no repetition; powers on many Yamaha receivers
static const microseconds_t arrayF[] = {
417U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 611U, 167U, 278U, 167U, 444U, 167U, 65535U 
};
 // NEC(1) 122 29 with no repetition; powers on many Yamaha receivers
static const microseconds_t arrayB[] = {
417U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 65535U 
};
 // NEC(1) 122 29 with no repetition; powers on many Yamaha receivers
static const microseconds_t arrayO[] = {
 417U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 278U, 167U, 611U, 167U, 444U, 167U, 611U, 167U, 278U, 167U, 278U, 167U, 778U, 167U, 278U, 167U, 65535U 
 };
 




static const IrSequence irSequence0(array0, sizeof(array0) / sizeof(microseconds_t));
static const IrSequence irSequence1(array1, sizeof(array1) / sizeof(microseconds_t));
static const IrSequence irSequence2(array2, sizeof(array2) / sizeof(microseconds_t));
static const IrSequence irSequence3(array3, sizeof(array3) / sizeof(microseconds_t));
static const IrSequence irSequence4(array4, sizeof(array4) / sizeof(microseconds_t));
static const IrSequence irSequence5(array5, sizeof(array5) / sizeof(microseconds_t));


static const IrSequence irSequence6(array6, sizeof(array6) / sizeof(microseconds_t));
static const IrSequence irSequence7(array7, sizeof(array7) / sizeof(microseconds_t));
static const IrSequence irSequence8(array8, sizeof(array8) / sizeof(microseconds_t));
static const IrSequence irSequence9(array9, sizeof(array9) / sizeof(microseconds_t));

static const IrSequence irSequenceU(arrayU, sizeof(arrayU) / sizeof(microseconds_t));
static const IrSequence irSequenceD(arrayD, sizeof(arrayD) / sizeof(microseconds_t));


static const IrSequence irSequenceF(arrayF, sizeof(arrayF) / sizeof(microseconds_t));
static const IrSequence irSequenceB(arrayB, sizeof(arrayB) / sizeof(microseconds_t));
static const IrSequence irSequenceO(arrayO, sizeof(arrayO) / sizeof(microseconds_t));




static dutycycle_t dutyCycle;
IrSender* irSender;

void setup() {
    Serial.begin(115200);
    Serial1.begin(115200);
    while (!Serial1);
    if (Board::getInstance()->hasHardwarePwm())
        Serial.println(F("Hardware PWM available!"));
    else
        Serial.println(F("Hardware PWM NOT available, will be emulated in software."));
    randomSeed(analogRead(A0));
    dutyCycle = (dutycycle_t) random(20,80);
    irSender = IrSenderPwm::getInstance(true, PIN);
}

void loop() {
    if (Serial1.available()) {
   
   Serial.print("sendcommand ");
  int commands = Serial1.parseInt();
   Serial.println(commands);
    if(commands == 1){
    
       irSender->send(irSequence4, necFrequency, 60);
       delay(300);
       
        irSender->send(irSequence3, necFrequency, 80);
          delay(300);
       
         irSender->send(irSequence0, necFrequency, dutyCycle);
       Serial.print(F("Shooting @ pin "));
    Serial.print(irSender->getPin(), DEC);
    Serial.print("Discovery");
    Serial.print(dutyCycle, DEC);
    Serial.println("%");
  
    }else if(commands== 2){
       irSender->send(irSequence5, necFrequency, dutyCycle);
        delay(200);
        irSender->send(irSequence2, necFrequency, dutyCycle);
         delay(200);
         irSender->send(irSequence0, necFrequency, dutyCycle);
       Serial.print(F("Shooting @ pin "));
    Serial.print(irSender->getPin(), DEC);
    Serial.print(F(" with duty cycle "));
    Serial.print(dutyCycle, DEC);
    Serial.println("%");
    delay(5000) ;
    }
 
    if(commands== 3){
       irSender->send(irSequence4, necFrequency, dutyCycle);
       delay(200);
       
        irSender->send(irSequence8, necFrequency, dutyCycle);
          delay(200);
       
         irSender->send(irSequence4, necFrequency, dutyCycle);
       Serial.print(F("9xm music "));
    Serial.print(irSender->getPin(), DEC);
    Serial.print("Discovery");
    Serial.print(dutyCycle, DEC);
    Serial.println("%");
  
    }

  if(commands== 4){
       irSender->send(irSequence3, necFrequency, dutyCycle);
       delay(200);
       
        irSender->send(irSequence2, necFrequency, dutyCycle);
          delay(200);
       
         irSender->send(irSequence5, necFrequency, dutyCycle);
       Serial.print(F("News24 "));
    Serial.print(irSender->getPin(), DEC);
    Serial.print("Discovery");
    Serial.print(dutyCycle, DEC);
    Serial.println("%");
  
    }


    if(commands== 5){
       irSender->send(irSequence3, necFrequency, dutyCycle);
       delay(200);
       
        irSender->send(irSequence1, necFrequency, dutyCycle);
          delay(200);
       
         irSender->send(irSequence5, necFrequency, dutyCycle);
       Serial.print(F("India TV "));
    Serial.print(irSender->getPin(), DEC);
    Serial.print("Discovery");
    Serial.print(dutyCycle, DEC);
    Serial.println("%");
  }

   if(commands== 6){
       irSender->send(irSequenceF, necFrequency, dutyCycle);
       delay(200);
       
       Serial.print(F("India TV "));
    Serial.print(irSender->getPin(), DEC);
    Serial.print("Forwad");
    Serial.print(dutyCycle, DEC);
    Serial.println("%");
  }

   if(commands== 7){
       irSender->send(irSequenceO, necFrequency, dutyCycle);
       delay(200);
       
       Serial.print(F(" TV off"));
    Serial.print(irSender->getPin(), DEC);
    Serial.print("Discovery");
    Serial.print(dutyCycle, DEC);
    Serial.println("%");
  }

    if(commands== 8){
       irSender->send(irSequenceU, necFrequency, dutyCycle);
       delay(200);
       
       Serial.print(F("volume up"));
    Serial.print(irSender->getPin(), DEC);
    Serial.print("Discovery");
    Serial.print(dutyCycle, DEC);
    Serial.println("%");
  }

    }
}
