import os
import sys, getopt
import signal
import time
#from espeak import espeak
#from gtts import gTTS

from edge_impulse_linux.audio import AudioImpulseRunner
#from aiy.voice.audio import AudioFormat, play_wav, record_file, Recorder

from aiy.board import Board
from aiy.voice.audio import AudioFormat, play_wav, record_file, Recorder

runner = None

def signal_handler(sig, frame):
    print('Interrupted')
    if (runner):
        runner.stop()
    sys.exit(0)

signal.signal(signal.SIGINT, signal_handler)

def help():
    print('python classify.py <path_to_model.eim> <audio_device_ID, optional>' )

def main(argv):
    try:
        opts, args = getopt.getopt(argv, "h", ["--help"])
    except getopt.GetoptError:
        help()
        sys.exit(2)

    for opt, arg in opts:
        if opt in ('-h', '--help'):
            help()
            sys.exit()

    if len(args) == 0:
        help()
        sys.exit(2)

    model = args[0]

    dir_path = os.path.dirname(os.path.realpath(__file__))
    modelfile = os.path.join(dir_path, model)

    with AudioImpulseRunner(modelfile) as runner:
        try:
            model_info = runner.init()
            labels = model_info['model_parameters']['labels']
            print('Loaded runner for "' + model_info['project']['owner'] + ' / ' + model_info['project']['name'] + '"')

            #Let the library choose an audio interface suitable for this model, or pass device ID parameter to manually select a specific audio interface
            selected_device_id = None
            if len(args) >= 2:
                selected_device_id=int(args[1])
                print("Device ID "+ str(selected_device_id) + " has been provided as an argument.")

            for res, audio in runner.classifier(device_id=selected_device_id):
                print('Result (%d ms.) ' % (res['timing']['dsp'] + res['timing']['classification']), end='')
                for label in labels:
                    score = res['result']['classification'][label]

                    print('%s: %.2f\t' % (label, score), end='')
                    #val =("")  //
                    #val=str((label,score ))
                    #print (val)
                    #print (val)
                    if label=="hello" and score >= 0.99:
                        print("ITS ELEPHANT VOICE  Saying Hello")
                        #espeak.synth("He is saying Hello ")
                        play_wav("hello.wav")
                        
                    if label==("angry") and score >= 1.00:
                        print("Its ELephant Voice saying I am Angry  ")

                        #espeak.synth("ITS Elephant SAYING I am Angry ")
                        play_wav("femaled1.wav")
                        
                    if label=="happy" and score >= 1.00:
                        print("Elephant Voice saying I am Very happy ")
                        #espeak.synth("Happy  happy I am Happy ")
                        play_wav("femaled.wav")
                        
                    if label==("lets go") and score >= 1.00:
                        print("Elephant Voice saying Hello  ")
                        #espeak.synth("he is saying leyts go")
                        play_wav("letsgo.wav")
                    
                    
                
                    
                    
                print('', flush=True)

        finally:
            if (runner):
                runner.stop()

if __name__ == '__main__':
    main(sys.argv[1:])
