#include <ESP8266WiFi.h>
#include <ESP8266mDNS.h>
#include <WiFiUdp.h>
#include <ArduinoOTA.h>
#include <Arduino.h>

#include <ESP8266WiFi.h>
#include <ESPAsyncTCP.h>
#include <ESPAsyncWebServer.h>

#ifndef STASSID
#define STASSID "IRONMAN"
#define STAPSK  "1234567890"
#endif
#include <ESPDash.h>

const char* ssid = STASSID;
const char* password = STAPSK;
const char* host = "OTA-LEDS";

int led_pin = 2;
#define N_DIMMERS 3
int dimmer_pin[] = {14, 5, 15};


/* Start Webserver */
AsyncWebServer server(80);

/* Attach ESP-DASH to AsyncWebServer */
ESPDash dashboard(&server); 

Card button(&dashboard, BUTTON_CARD, "green");
Card button1(&dashboard, BUTTON_CARD, "white");

Card slider(&dashboard, SLIDER_CARD, "red", "", 0, 255);
Card slider1(&dashboard, SLIDER_CARD, "green", "", 0, 255);
Card slider2(&dashboard, SLIDER_CARD, "blue", "", 0, 255);

void setup() {
  Serial.begin(115200);

  /* switch on led */
  pinMode(led_pin, OUTPUT);
  digitalWrite(led_pin, LOW);

  Serial.println("Booting");
  WiFi.mode(WIFI_STA);

  WiFi.begin(ssid, password);

  while (WiFi.waitForConnectResult() != WL_CONNECTED) {
    WiFi.begin(ssid, password);
    Serial.println("Retrying connection...");
  }
  /* switch off led */
  digitalWrite(led_pin, HIGH);

  /* configure dimmers, and OTA server events */
  analogWriteRange(1000);
  analogWrite(led_pin, 990);

  for (int i = 0; i < N_DIMMERS; i++) {
    pinMode(dimmer_pin[i], OUTPUT);
    analogWrite(dimmer_pin[i], 50);
  }

  ArduinoOTA.setHostname(host);
  ArduinoOTA.onStart([]() { // switch off all the PWMs during upgrade
    for (int i = 0; i < N_DIMMERS; i++) {
      analogWrite(dimmer_pin[i], 0);
    }
    analogWrite(led_pin, 0);
  });

  ArduinoOTA.onEnd([]() { // do a fancy thing with our board led at end
    for (int i = 0; i < 30; i++) {
      analogWrite(led_pin, (i * 100) % 1001);
      delay(50);
    }
  });

  ArduinoOTA.onError([](ota_error_t error) {
    (void)error;
    ESP.restart();
  });

  /* setup the OTA server */
  ArduinoOTA.begin();
  Serial.println("Ready");
  digitalWrite(2, HIGH);   // turn the LED on (HIGH is the voltage level)
  delay(1000);                       // wait for a second
  digitalWrite(2, LOW);    // turn the LED off by making the voltage LOW



  button.attachCallback([&](bool value){
    /* Print our new button value received from dashboard */
    Serial.println("Button Triggered: "+String((value)?"true":"false"));
    /* Make sure we update our button's value and send update to dashboard */
    button.update(value);
    digitalWrite(2, LOW); 
    dashboard.sendUpdates();
  });
    button1.attachCallback([&](bool value){
    /* Print our new button value received from dashboard */
    Serial.println("Button Triggered: "+String((value)?"true":"false"));
    /* Make sure we update our button's value and send update to dashboard */
    button.update(value);
    dashboard.sendUpdates();
  });

  slider.attachCallback([&](int value){
     Serial.println("Slider Triggered: "+String(value));
    slider.update(value);
    analogWrite(2, value);
    analogWrite(16, value);
    dashboard.sendUpdates();
  });
   slider1.attachCallback([&](int value){
     Serial.println("Slider Triggered: "+String(value));
    slider.update(value);
    analogWrite(2, value);
    analogWrite(5, value);
    dashboard.sendUpdates();
  });
   slider2.attachCallback([&](int value){
     Serial.println("Slider Triggered: "+String(value));
    slider.update(value);
    analogWrite(2, value);
    analogWrite(4, value);
    dashboard.sendUpdates();
  });


  server.begin();
}

void loop() {
  ArduinoOTA.handle();
  digitalWrite(2, HIGH);   // turn the LED on (HIGH is the voltage level)
  delay(600);                       // wait for a second
  digitalWrite(2, LOW);    // turn the LED off by making the voltage LOW
  delay(600);    
}
