#include <LM35.h>
#include <Wire.h>
#include "MAX30100_PulseOximeter.h"

#define REPORTING_PERIOD_MS     1000

PulseOximeter pox;

uint32_t tsLastReport = 0;

LM35 temp(A0);
 void onBeatDetected()
{
    Serial.println("Beat!");
}

void setup() 
{
 
  Serial.begin(9600); 
  
    if (!pox.begin()) {
        Serial.println("FAILED");
        for(;;);
    } else {
        Serial.println("SUCCESS");
    }
    pox.setOnBeatDetectedCallback(onBeatDetected);
}

void loop() 
{
  Serial.print("Temp - ");  //Send a text to serial
  Serial.print(temp.cel()); //It gets the temperature in celcius and send to serial
  pox.update();
  if ((temp.cel() > 39)){
    digitalWrite(10, HIGH);
  }else{
    digitalWrite(10, LOW);
  }
 
    if (millis() - tsLastReport > REPORTING_PERIOD_MS) {
        Serial.print("Heart rate:");
        Serial.print(pox.getHeartRate());
        Serial.print("bpm / SpO2:");
        Serial.print(pox.getSpO2());
        Serial.println("%");
        Serial.print("Temp - ");  
        Serial.print(temp.cel());
        tsLastReport = millis();
    }
}
