#include <SPIFFS.h>
#include <SPI.h>

#include <ArduinoWebsockets.h>
#include <WiFi.h>

#include <TJpg_Decoder.h>
#include <TFT_eSPI.h>

//#include "soc/soc.h" //disable brownout problems
//#include "soc/rtc_cntl_reg.h"  //disable brownout problems

const char* imageFileName = "/camimage.jpeg";
const char* host     = "192.168.10.10";
const char* url      = "/";

using namespace websockets;
WebsocketsServer server;
WebsocketsClient client;

const char* ssid = "bera2"; //Enter SSID
const char* password = "99690343141"; //Enter Password
const char* websockets_server_host = "192.168.10.10"; //Enter server adress
const uint16_t websockets_server_port = 80; // Enter server port
 
TFT_eSPI tft = TFT_eSPI();         // Invoke custom library
boolean SDInited = false;

bool tft_output(int16_t x, int16_t y, uint16_t w, uint16_t h, uint16_t* bitmap) {
   // Stop further decoding as image is running off bottom of screen
  if ( y >= tft.height() ) return 0;

  // This function will clip the image block rendering automatically at the TFT boundaries
  tft.pushImage(x, y, w, h, bitmap);

  // This might work instead if you adapt the sketch to use the Adafruit_GFX library
//   tft.drawRGBBitmap(x, y, bitmap, w, h);

  // Return 1 to decode next block
  return 1;
}


void setup() {
   Serial.begin(115200);
  delay(1000);
WiFi.begin(ssid, password);
 while (WiFi.status() != WL_CONNECTED) {
    delay(100);
    Serial.print(".");
  }
  Serial.println("");
  Serial.println("WiFi connected");

  Serial.print("Local IP ");
  Serial.print(WiFi.localIP());
  Serial.println("' to connect"); 

  if(!SPIFFS.begin(true)){
    Serial.println("SPIFFS init failed!");
    while(1) yield();
  }else{
    SDInited = true;
  } 

  tft.begin();
  tft.setRotation(0);  
  tft.setTextColor(0xFFFF, 0x0000);
  tft.fillScreen(TFT_BLUE);
  tft.setSwapBytes(true); // We need to swap the colour bytes (endianess)
  // The jpeg image can be scaled by a factor of 1, 2, 4, or 8
  TJpgDec.setJpgScale(1);  // 1 for normal; 4 For smaller ILI9163
  // The decoder must be given the exact name of the rendering function above
  TJpgDec.setCallback(tft_output);

   Serial.println("Connected to Wifi, Connecting to server.");
    // try to connect to Websockets server
//  bool connected = client.connect(websockets_server_host, websockets_server_port, "/");

}

void loop() {
  bool connected = client.connect(websockets_server_host, websockets_server_port, "/");
     if(connected)
     client.send("Hello Server"); 
 else {
   esp_restart();  
 }
 
  if(SDInited){
    if(server.poll()){
      client = server.accept();
      Serial.println("Server connected");
    }

    if(client.available()){
      client.poll();

      WebsocketsMessage msg = client.readBlocking();
      boolean isSaved = fileWrite(imageFileName, msg);
   //  delay(100);
      if(isSaved ){
        uint32_t t = millis();

        // Get the width and height in pixels of the jpeg if you wish
        uint16_t w = 0, h = 0;
        TJpgDec.getFsJpgSize(&w, &h, imageFileName); // Note name preceded with "/"
        Serial.print("Width = "); Serial.print(w); Serial.print(", height = "); Serial.println(h);
      
        // Draw the image, top left at 0,0
        TJpgDec.drawFsJpg(0, 0, imageFileName);
     // delay(100);
        // How much time did rendering take (ESP8266 80MHz 271ms, 160MHz 157ms, ESP32 SPI 120ms, 8bit parallel 105ms
        t = millis() - t;
        Serial.print(t); Serial.println(" ms");
           }
        }
       }
 //      delay(10);
}

boolean fileWrite(String name, WebsocketsMessage content){
   SPIFFS.remove("/camimage.jpeg");
   File file = SPIFFS.open(name.c_str(), FILE_WRITE); //"w");
   if(!file){
    String errorMsg = "Can't open file";
    Serial.println(errorMsg);
      return false;
  }else{
    file.write((const uint8_t*) content.c_str(), content.length());
    file.close();
   
    return true;
  }
  
}
