#include <Arduino.h>
#if defined(ESP8266)
  /* ESP8266 Dependencies */
  #include <ESP8266WiFi.h>
  #include <ESPAsyncTCP.h>
  #include <ESPAsyncWebServer.h>
#elif defined(ESP32)
  /* ESP32 Dependencies */
  #include <WiFi.h>
  #include <AsyncTCP.h>
  #include <ESPAsyncWebServer.h>
#endif
#include <ESPDash.h>


/* Your WiFi Credentials */
const char* ssid = "Airtel_8340704067"; // SSID
const char* password = "air34705"; // Password

/* Start Webserver */
AsyncWebServer server(80);

/* Attach ESP-DASH to AsyncWebServer */
ESPDash dashboard(&server); 

/* 
  Button Card
  Format - (Dashboard Instance, Card Type, Card Name)
*/
Card button(&dashboard, BUTTON_CARD, "Test Button");

/* 
  Slider Card
  Format - (Dashboard Instance, Card Type, Card Name, Card Symbol(optional), int min, int max)
*/
Card slider(&dashboard, SLIDER_CARD, "Test Slider", "", 0, 100);


void setup() {
  Serial.begin(115200);
  ////////
  pinMode(2,OUTPUT);
  pinMode(12,OUTPUT);
  ////////
  /* Connect WiFi */
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);
  if (WiFi.waitForConnectResult() != WL_CONNECTED) {
      Serial.printf("WiFi Failed!\n");
      return;
  }
  Serial.print("IP Address: ");
  Serial.println(WiFi.localIP());

  /* Attach Button Callback */
  button.attachCallback([&](bool value){
  /* Print our new button value received from dashboard */
  Serial.println("Button Triggered: "+String((value)?"true":"false"));
  
   /* Make sure we update our button's value and send update to dashboard */
  button.update(value);
  if(value==true){
      Serial.println("light on");
      digitalWrite(2,1);
      analogWrite(12, 255);
      
    }
    if(value==false){
       Serial.println("light on");
        digitalWrite(2,0);
      analogWrite(12, 0);
    }
  dashboard.sendUpdates();
  });

  /* Attach Slider Callback */
  slider.attachCallback([&](int value){
    /* Print our new slider value received from dashboard */
    Serial.println("Slider Triggered: "+String(value));
    /* Make sure we update our slider's value and send update to dashboard */
    slider.update(value);
    analogWrite(12, value);
    dashboard.sendUpdates();
  });

  /* Start AsyncWebServer */
  server.begin();
}

void loop() {
  /* Nothing so far */
}
