/*
  -----------------------------
  ESPDASH Lite - Interactive Example
  -----------------------------

  Skill Level: Intermediate

  In this example we will be creating a interactive dashboard which consists 
  of a button and a slider.

  Github: https://github.com/ayushsharma82/ESP-DASH
  WiKi: https://ayushsharma82.github.io/ESP-DASH/

  Works with both ESP8266 & ESP32

  -------------------------------

  Upgrade to ESP-DASH Pro: https://espdash.pro

*/

#include <Arduino.h>
#if defined(ESP8266)
  /* ESP8266 Dependencies */
  #include <ESP8266WiFi.h>
  #include <ESPAsyncTCP.h>
  #include <ESPAsyncWebServer.h>
#elif defined(ESP32)
  /* ESP32 Dependencies */
  #include <WiFi.h>
  #include <AsyncTCP.h>
  #include <ESPAsyncWebServer.h>
#endif
#include <ESPDash.h>


/* Your WiFi Credentials */
const char* ssid = "Airtel_8340704067"; // SSID
const char* password = "air34705"; // Password

/* Start Webserver */
AsyncWebServer server(80);

/* Attach ESP-DASH to AsyncWebServer */
ESPDash dashboard(&server); 
int LEDPIn=12;

/* 
  Button Card
  Format - (Dashboard Instance, Card Type, Card Name)
*/
Card button(&dashboard, BUTTON_CARD, "Test Button");

/* 
  Slider Card
  Format - (Dashboard Instance, Card Type, Card Name, Card Symbol(optional), int min, int max)
*/


void setup() {
  Serial.begin(115200);
  pinMode(LEDPIn,OUTPUT);
  pinMode(2,OUTPUT);
  pinMode(16,OUTPUT);
  /* Connect WiFi */
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);
  if (WiFi.waitForConnectResult() != WL_CONNECTED) {
      Serial.printf("WiFi Failed!\n");
      return;
  }
  Serial.print("IP Address: ");
  Serial.println(WiFi.localIP());

  /* Attach Button Callback */
  button.attachCallback([&](bool value){
    /* Print our new button value received from dashboard */
    Serial.println("Button Triggered: "+String((value)?"true":"false"));
    /* Make sure we update our button's value and send update to dashboard */
    button.update(value);
    if(value==true){
      digitalWrite(LEDPIn,1);
      Serial.println("light on");
      digitalWrite(2,1);
      digitalWrite(16,1);
      
    }
    if(value==false){
      digitalWrite(LEDPIn,0);
       Serial.println("light on");
        digitalWrite(2,0);
      digitalWrite(16,0);
    }
    dashboard.sendUpdates();
  });

  /* Attach Slider Callback */

  /* Start AsyncWebServer */
  server.begin();
}

void loop() {
  /* Nothing so far */
}
