from luma.core.interface.serial import i2c
from luma.core.render import canvas
from luma.oled.device import ssd1309, ssd1325, ssd1331, sh1106
from time import sleep
from gpiozero import Button
import time
from gsmHat import GSMHat, SMS, GPS

gsm = GSMHat('/dev/ttyS0', 4800)
button = Button(17)
button2 = Button(27)

serial = i2c(port=1, address=0x3D)
device = ssd1309(serial, rotate=0)

# Box and text rendered in portrait mode
with canvas(device) as draw:
    draw.rectangle(device.bounding_box, outline="white", fill="black")
    draw.text((10, 40), "blink eye lightcontrol", fill="white")
    draw.text((10, 50), "Hello blink eye", fill="white")

while True:
    button.wait_for_press()
    print("calling")
    if gsm.SMS_available() > 0:
        newSMS = gsm.SMS_read()
        print('Got new SMS from number %s' % newSMS.Sender)
        print('It was received at %s' % newSMS.Date)
        print('The message is: %s' % newSMS.Message)
        with canvas(device) as draw:
        draw.rectangle(device.bounding_box, outline="white", fill="black")
        draw.text((10, 40), "newSMSfill="white")
                  
    button2.wait_for_press()
    Number = '7979952235'
    gsm.Call(Number)  
    with canvas(device) as draw:
        draw.rectangle(device.bounding_box, outline="white", fill="black")
        draw.text((10, 40), "Calling", fill="white")
        draw.text((10, 60), "7979952235", fill="white")
