/*!
  @file geiger.ino
  @brief    Detect CPM radiation intensity, the readings may have a large deviation at first, and the data tends to be stable after 3 times
  @copyright   Copyright (c) 2010 DFRobot Co.Ltd (http://www.dfrobot.com)
  @licence     The MIT License (MIT)
  @author [fengli](li.feng@dfrobot.com)
  @version  V1.0
  @date  2021-9-17
  @get from https://www.dfrobot.com
  @https://github.com/DFRobot/DFRobot_Geiger
*/

#include <DFRobot_Geiger.h>
#if defined ESP32
#define detect_pin 2
#else
#define detect_pin 3
#endif
#include <Arduino.h>
#include <U8g2lib.h>

#ifdef U8X8_HAVE_HW_SPI
#include <SPI.h>
#endif
#ifdef U8X8_HAVE_HW_I2C
#include <Wire.h>
#endif
U8G2_SSD1306_128X64_NONAME_F_HW_I2C u8g2(U8G2_R0, /* reset=*/ U8X8_PIN_NONE, /* clock=*/ 22, /* data=*/ 21);   // ESP32 Thing, HW I2C with pin remapping

/*!
   @brief Constructor
   @param pin   External interrupt pin
*/
DFRobot_Geiger  geiger(detect_pin);

void setup()
{
  Serial.begin(115200);
  

  u8g2.begin();

  //Start counting, enable external interrupt
  geiger.start();
}

void loop() {
  //Start counting, enable external interrupt
  //geiger.start();
  delay(3000);
  //Pause the count, turn off the external interrupt trigger, the CPM and radiation intensity values remain in the state before the pause
  //geiger.pause();
  //Get the current CPM, if it has been paused, the CPM is the last value before the pause
  //Predict CPM by falling edge pulse within 3 seconds, the error is ±3CPM
  Serial.println(geiger.getCPM());
  //Get the current nSv/h, if it has been paused, nSv/h is the last value before the pause
  Serial.println(geiger.getnSvh());
  //Get the current μSv/h, if it has been paused, the μSv/h is the last value before the pause
  Serial.println(geiger.getuSvh());
    
    u8g2.clearBuffer();
    u8g2.setFont(u8g2_font_profont17_tr);
    u8g2.setCursor(50,17);
    u8g2.println("GERIER="); // display a message
    u8g2.setCursor(55,40);
    u8g2.println(geiger.getCPM());
    u8g2.println("CPM");
    u8g2.setFont(u8g2_font_profont15_tr);
    u8g2.setCursor(10,50);
    u8g2.println("NSVH="); // display a message
    u8g2.println(geiger.getnSvh());

    
    u8g2.setFont(u8g2_font_open_iconic_app_4x_t);
    u8g2.drawGlyph(10, 35, 72); 
    u8g2.sendBuffer();
}
  
