import cv2
import pytesseract as tess
from gpiozero import LED
from time import sleep
gate = LED(21)

#UPDATE YOUR DATABASE IN THE FOLLOWING STRING
carpool=['OR06F4630','UP16BY0538','MP10CA4768','MH03AW2684','MHO3AW2684']
def check(image_file):
  #carpool=["OR06F4630","UP16BJ0538","MP10CA4768","MH03AW2684"]  
  width1 =  [650,660,670] #560,570,580,590,600,610,620,630,640,650,660,670]   #670 800
  height1 = 475   #475
  for wd in width1:
  # load the image, resize it, and convert it to grayscale
   image = cv2.imread(image_file)  #"6.jpeg")
   image = cv2.resize(image, (wd, height1))
   gray = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY)

# load the number plate detector
   n_plate_detector = cv2.CascadeClassifier("haarcascade_russian_plate_number.xml")
# detect the number plates in the grayscale image
   detections = n_plate_detector.detectMultiScale(gray, scaleFactor=1.05, minNeighbors=7)

# loop over the number plate bounding boxes
   for (x, y, w, h) in detections:
    # draw a rectangle around the number plate
    cv2.rectangle(image, (x, y), (x + w, y + h), (0, 255, 255), 2)
    cv2.putText(image, "Number plate detected", (x - 20, y - 10),
                cv2.FONT_HERSHEY_COMPLEX, 0.5, (0, 255, 255), 2)

    # extract the number plate from the grayscale image
    number_plate = gray[y:y + h, x:x + w]
    number_plate = cv2.resize(number_plate,(170,100))  #170,100

   text = tess.image_to_string(number_plate, lang='eng')
   text = text.strip()
   text = text.replace(" ","")
   if(text.isalnum()==True):
     print("Number Plate: ",wd,text )
     for car in carpool:
       #print(car,text)
       gate.off()
       if (car in text):
         print(text ,'found in pool')
         gate.on()
         sleep(1.0)
         gate.off()
         
