

#include <Arduino.h>
#if defined(ESP8266)
  /* ESP8266 Dependencies */
  #include <ESP8266WiFi.h>
  #include <ESPAsyncTCP.h>
  #include <ESPAsyncWebServer.h>
#elif defined(ESP32)
  /* ESP32 Dependencies */
  #include <WiFi.h>
  #include <AsyncTCP.h>
  #include <ESPAsyncWebServer.h>
#endif
#include <ESPDash.h>

#include <sleepbreathingradar.h>

SleepBreathingRadar radar;
/* Your WiFi Credentials */
const char* ssid = "JioFiber-4G"; // SSID
const char* password = "1234567890"; // Password

/* Start Webserver */
AsyncWebServer server(80);

/* Attach ESP-DASH to AsyncWebServer */
ESPDash dashboard(&server); 

/* 
  Dashboard Cards 
  Format - (Dashboard Instance, Card Type, Card Name, Card Symbol(optional) )
*/
Card card1(&dashboard, GENERIC_CARD, "Person status");
Card card2(&dashboard, STATUS_CARD, "Person Activity", "success");
Card card4(&dashboard, STATUS_CARD, "sleep data", "success");

Card card3(&dashboard, PROGRESS_CARD, "Breadthing rate", "", 0, 55);







void setup() {
  Serial.begin(115200);
  radar.SerialInit();
  Serial.begin(9600);
  delay(1500);
  Serial.println("Ready");
  card1.update("Ready");

  /* Connect WiFi */
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);
  if (WiFi.waitForConnectResult() != WL_CONNECTED) {
      Serial.printf("WiFi Failed!\n");
      return;
  }
  Serial.print("IP Address: ");
  Serial.println(WiFi.localIP());

  /* Start AsyncWebServer */
  server.begin();
}

void loop() {
  
 
 radar.recvRadarBytes();                       //Receive radar data and start processing
 if (radar.newData == true)
 {                  //The data is received and transferred to the new list dataMsg[]
    byte dataMsg[radar.dataLen+1] = {0x00};
    dataMsg[0] = 0x55;                         //Add the header frame as the first element of the array
    for (byte n = 0; n < radar.dataLen; n++)dataMsg[n+1] = radar.Msg[n];  //Frame-by-frame transfer
    radar.newData = false;                     //A complete set of data frames is saved
    
   // radar.ShowData(dataMsg);                 //Serial port prints a set of received data frames
    radar.Situation_judgment(dataMsg); 
    String situ= Serial.readString() ;
    card1.update(situ);
    delay(50);
    
    radar.Bodysign_judgment(dataMsg, 1, 15); 
    String body= Serial.readString() ;
    card2.update(body, "success");//Use radar built-in algorithm to output human motion status
    delay(50);

   radar.Sleep_inf(dataMsg);
   int breadthrate= Serial.parseInt();
   String respire= Serial.readString() ;
   card4.update(respire, "success");
   //Use radar built-in algorithm to output human motion status//Output of human movement using sign parameters
   card3.update(breadthrate, "ps");
  
  }


  /* Send Updates to our Dashboard (realtime) */
  dashboard.sendUpdates();

  /* 
    Delay is just for demonstration purposes in this example,
    Replace this code with 'millis interval' in your final project.
  */
  delay(800);
}
