from picamera.array import PiRGBArray # Generates a 3D RGB array
from picamera import PiCamera # Provides a Python interface for the RPi Camera Module
import time # Provides time-related functions
import cv2 # OpenCV library
from numberplate22 import check

import subprocess
from gpiozero import DistanceSensor
ultrasonic = DistanceSensor(echo=17, trigger=4, threshold_distance=0.5, max_distance=4)

#check("6.jpeg")
width =  670   #670 800
height = 480
camera = PiCamera()
camera.resolution = (width,height)
camera.framerate = 32
raw_capture = PiRGBArray(camera, size=(width,height))
time.sleep(0.1)
while True:
 for frame in camera.capture_continuous(raw_capture, format="bgr", use_video_port=True):
    x = int(ultrasonic.distance*100)
    image = frame.array
    if(x>300) :
        print(x)
        exitCode = subprocess.call(["espeak","-ven+f3", "Distance is %d centi meter come closer " % x])
    if(x<=300):
        cv2.imwrite("test.png",image)
        check("car33.png")  #6.jpeg")
        #check("test.png")
        #cv2.imshow("Frame", image)
        #time.sleep(2)
        #cv2.destroyAllWindows()


