// ADC/DAC Trainer sketch
// by Asokan Ambali and Chinchu Gace Lukose
// The sketch using two third party libraries 
// LiquidCrystal_I2C.h and Wire.h this has to be downloaded and 
// installed this libraries are required for 
// interfacing I2C LCD.
#include <Wire.h> // Library Serial communication 
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27, 20, 4);//Plz change the memory address(0x27) according to your LCD
int led = 9; // Digital pin 9 as led        
int out; // A integer variable assigned as "out"
int sw = 12;//Pin 12 as sw

void setup() 
{
  pinMode(led, OUTPUT); // led pin as output
  pinMode(sw, INPUT_PULLUP);// sw pin as input with internal pull-up
  lcd.clear();  // initialize LCD  
  lcd.backlight(); // LCD backlight ON
	lcd.begin();

	// Turn on the blacklight and print a message.
	lcd.backlight();
  lcd.setCursor(1,0);// se LCD cursor at 2nd column 1st raw
  lcd.print("  ADC-DAC Trainer  "); //print text message LCD
  lcd.setCursor(0,1);// set LCD cursor at 1st column 2nd raw
  lcd.print("Dsn by A Ambali and");//print text message LCD
  lcd.setCursor(1,2);// set LCD cursor at 2st column 3nd raw
  lcd.print(" Chimchu G Lukose  ");//print text message LCD
  lcd.setCursor(1,3);// set LCD cursor at 2st column 4nd raw
  lcd.print("Initializing.......");//print text message LCD
  delay(3000);  //one second delay
  lcd.clear(); 
  lcd.backlight();// initialize LCD  
  lcd.setCursor(1,0);
  lcd.print("A-D&D-A TRAINER KIT");
  lcd.setCursor(0,1);
  lcd.print("Plz wait ..........");
  lcd.setCursor(1,2);
  lcd.print("Initializing.......");
  lcd.setCursor(1,3);
  lcd.print("                   ");
  delay(3000);
  lcd.clear();  // initialize LCD  
  lcd.setCursor(1,0);
  lcd.print("KEEP SW1-SW8 AT OFF");
  lcd.setCursor(1,1);
  lcd.print("      POSITION   ");
  delay(4000);
  lcd.setCursor(0,2);
  lcd.print("ENSURE THE ALL EIGHT");
  lcd.setCursor(1,3);
  lcd.print(" LEDs ARE BLINKING  ");  
  DDRD=0B11111111; // set portD as output
  PORTD=0;// write decimal 0 to the portD
  delay(500);
  PORTD=255;// write decimal 255 (binary 11111111) to the portD
  delay(500);
  PORTD=0;// write decimal 0 to the portD
  delay(500);
  PORTD=255;// write decimal 255 (binary 11111111) to the portD
  delay(500);
  PORTD=0;
  delay(500);
  PORTD=255;
  delay(500);
  PORTD=0;
  delay(500);//This part is for blinking all 8 LEDs connected on portD
  lcd.clear(); 
}

void loop() // the main program starts from here
{
  if (digitalRead(sw)==LOW)//execute the command if sw pin is LOW
  {
    
    dac();// execute the "dac" Subroutine
  }
  if (digitalRead(sw)==HIGH)//execute the command if sw pin is HIGH
  {
    adc();// execute the "adc" Subroutine
  }
}

void dac()// "dac" subroutine
{
  DDRD=0B000000000;// set portD as input
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("DIGITAL 2 ANALOG MOD");
  lcd.setCursor(0, 1);
  lcd.print("Connect a Voltmeter");
  lcd.setCursor(0, 2);
  lcd.print("  Across T1 & T2  ");  
  lcd.setCursor(0, 3);
  lcd.print("Meter shows 0 to 5V ");
  delay(2000);
  analogWrite(led, 25);//Line 94 to 106 dac out pin Voltage will increase from 0-5V with 6 steps
  delay(400);
  analogWrite(led, 25);
  delay(400);
  analogWrite(led, 50);
  delay(400);
  analogWrite(led, 100);
  delay(400);
  analogWrite(led, 150);
  delay(400);
  analogWrite(led, 200);
  delay(400);
  analogWrite(led, 255);
  delay(1000);
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("DIGITAL 2 ANALOG MOD");
  while(1) //indefinite loop
  {
   out=PIND; //read data from portD and transfer to variable "out"
   analogWrite(led, out);// writing the port data to adc pin
  lcd.setCursor(0, 1);
  lcd.print(" SET DEFFERENT DATA ");
  lcd.setCursor(0, 2);
  lcd.print("USING S1-S8 AND NOTE ");
  lcd.setCursor(0, 3);
  lcd.print("THE VOLTAGE READINGS");
  delay(200);
  if (digitalRead(sw)==HIGH)// if "sw" pin status is HIGH execute the command
  {
   break; // escape from the indefinite loop
  }
 }
}//end of "dac" subroutine


void adc()//"adc" subroutine
{
  DDRD=0B11111111;// set portD as output
  lcd.clear();// clear data from display 
  lcd.setCursor(0, 0);
  lcd.print("ANALOG 2 DIGITAL MOD");
  lcd.setCursor(0,1);
  lcd.print("KEEP SW1-SW8 AT OFF");
  lcd.setCursor(0,2);
  lcd.print("POSITION ENSURE LEDs  ");
  lcd.setCursor(0, 3);
  lcd.print("   COUNTING 0-255   ");
  int count=0; //special variable to get a sequential increment
  while(1)//indefinite loop
  {
   PORTD=count; //line 145 - 147 will generate and write digital word from 1 to 255 to portD
   count++;//increment the variable "count"
   delay(50);
   if(count==255) // if count reaches 255 reset the count and exit from loop
   {
    count=0;
    break;
   }
  }
  delay(200);
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("ANALOG 2 DIGITAL MOD");
  lcd.setCursor(0, 1);
  lcd.print("Connect a Voltmeter");
  lcd.setCursor(0, 2);
  lcd.print("on T2&T3,Set ADC V &");  
  lcd.setCursor(0, 3);
  lcd.print("note the Digial OUT");
  while(1)//indefinite loop
  {
  int sensorValue = analogRead(A1); // read analog data from A1
  float voltage = sensorValue * (255.0/1023.0);//maximum data limited to 255
  PORTD=voltage;// write the calculated data to portD
  delay(200);
  if(digitalRead(sw)==LOW)//exit loop if switch status is LOW
  {
   break;
  }
 }
}
