import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation

# create a figure and subplot for the polar plot
fig, ax = plt.subplots(subplot_kw={'projection': 'polar'})

# initialize the plot with empty data
line, = ax.plot([], [])

# set the axis limits and labels
ax.set_ylim(0, 1.2)
ax.set_yticklabels([])
ax.set_xticklabels(['0', '', '45', '', '90', '', '135', '', '180', '', '-135', '', '-90', '', '-45'])

# create a function to update the plot
def update_plot(i):
    # generate some fake distance and angle data
    distances = np.random.rand(5)
    angles = np.linspace(0, 2*np.pi, 5, endpoint=False)
    # update the plot with the new data
    line.set_data(angles, distances)
    return line,

# create an animation object to update the plot every 100ms
ani = FuncAnimation(fig, update_plot, interval=100)

# display the plot
plt.show()
