import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
import numpy as np
import serial

# Open the serial port for communication with the lidar
ser = serial.Serial('/dev/ttyUSB0', 115200, timeout=1)

# Create a figure and axes for the plot
fig, ax = plt.subplots()
x = np.linspace(0, 360, 360)
line, = ax.plot(x, np.zeros(360))

# Function to read data from the lidar and update the plot
def update(frame):
    # Read data from the lidar
    data = ser.readline().decode().strip().split(',')
    data = list(map(int, data))

    # Update the plot with the new data
    line.set_ydata(data)
    ax.relim()
    ax.autoscale_view()

# Create an animation object and start the animation
ani = FuncAnimation(fig, update, interval=50)
plt.show()
