import serial
import time

# Connect to YDX2 lidar via serial port
ser = serial.Serial('/dev/ttyUSB0', 115200, timeout=1)  # Replace 'COM3' with the appropriate port name
time.sleep(2)  # Wait for serial port to initialize

# Continuously read angle and distance data from lidar
while True:
    # Read one line of data from lidar
    line = ser.readline().decode().strip()
    
    # Parse angle and distance from line of data
    try:
        angle, distance = map(float, line.split(','))
    except ValueError:
        continue  # Ignore any malformed data
    
    # Print angle and distance data
    print(f"Angle: {angle:.2f} degrees, Distance: {distance:.2f} mm")
