
// This program uses the Library //
// ds3231-master.zip //

#include <Wire.h>
#include <ds3231.h>
#include <LiquidCrystal.h>

struct ts t; 
LiquidCrystal lcd (12 ,11 , 5, 4 , 3 , 2);// (rs, e, d4, d5, d6, d7)
char buffer [ 25 ] ;
char DOTW[8][12] = {"DUM" , "MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN" };
                  //  0       1      2      3      4      5      6      7   //
void setup() 
{
    Wire.begin();
    lcd.begin( 20, 4 ) ;
       
   // The following lines are uncommented 
   //    to set the time   //
/*
  DS3231_init( DS3231_CONTROL_INTCN ) ;
     t.hour= 15 ;  // hour : 24 hour format //
     t.min= 14 ;   // minute   //
     t.sec=0;      // seconds  //
     t.wday = 1 ;  // week day [ 1 .. 7 ]  //
     t.mday=3 ;   // date  //
     t.mon=1 ;    // month [1..12] //
     t.year=2022 ; //year  //
 
   DS3231_set(t); 
*/
}

void loop()
{
  DS3231_get(&t);
  
  lcd.setCursor ( 4 , 0 ) ;  // ( col , row ) //

  //    TIME   //
  if ( t.hour == 12 )
  {
    sprintf (buffer, "%02d:%02d:%02d PM",
             t.hour,t.min,t.sec);
  } else if ( t.hour > 12 )
  {    t.hour = t.hour - 12 ;
       sprintf (buffer, "%02d:%02d:%02d PM",
             t.hour,t.min,t.sec);
  } else
  {
     sprintf (buffer, "%02d:%02d:%02d AM",
          t.hour,t.min,t.sec);
  } 
  lcd.print ( buffer ) ;

  //    DATE and DAY     //
  lcd.setCursor ( 2 , 2 ) ;
  sprintf (buffer, "%02d/%02d/%04d  %s",
          t.mday,t.mon,t.year, DOTW[t.wday] ) ;
 
  lcd.print ( buffer ) ;

  delay ( 1000 ) ;
}
