

#include <Arduino.h>
#include "AsyncTelegram.h"
AsyncTelegram myBot;

const char* ssid = "JioFiber-4G";             // REPLACE mySSID WITH YOUR WIFI SSID
const char* pass = "1234567890";          // REPLACE myPassword YOUR WIFI PASSWORD, IF ANY
const char* token = "5170313679:AAEZDcnKskxjhrD4V8fayYvChlQtzXTpztc";     // REPLACE myToken WITH YOUR TELEGRAM BOT TOKEN

const uint8_t LED = LED_BUILTIN;
String masterkey;
String pwd;
String letters[6] = {"adv", "fdfdb", "fdfc", "fdfd", "efdf", "fmbff"};
String otpp = "";
String numbers[4]={"3213", "213213", "9999", "543646"};

void setup() {
	// initialize the Serial
	Serial.begin(115200);
	Serial.println("Starting TelegramBot...");

	WiFi.setAutoConnect(true);   
	WiFi.mode(WIFI_STA);

	WiFi.begin(ssid, pass);
	delay(500);
	while (WiFi.status() != WL_CONNECTED) {
		Serial.print('.');
		delay(500);
	}

	// To ensure certificate validation, WiFiClientSecure needs time updated
  // myBot.setInsecure(false);
  myBot.setClock("CET-1CEST,M3.5.0,M10.5.0/3");
	
	// Set the Telegram bot properies
	myBot.setUpdateTime(1000);
	myBot.setTelegramToken(token);

	// Check if all things are ok
	Serial.print("\nTest Telegram connection... ");
	myBot.begin() ? Serial.println("OK") : Serial.println("NOK");

	// set the pin connected to the LED to act as output pin
	pinMode(LED, OUTPUT);
	digitalWrite(LED, HIGH); // turn off the led (inverted logic!)

}


void loop() {
	// a variable to store telegram message data
	TBMessage msg;

	// if there is an incoming message...
	if (myBot.getNewMessage(msg)) {

		if (msg.text.equalsIgnoreCase("create otp 2235690")) { 
		 otpp =  letters[random(0, 6)] + numbers [random(0, 4)] ;
			                 // turn on the LED (inverted logic!)
			myBot.sendMessage(msg, "here is your otp" + otpp);        // notify the sender
		}
		else if (msg.text.equals(otpp)) {        // if the received message is "LIGHT OFF"...
			digitalWrite(LED, HIGH);                          // turn off the led (inverted logic!)
			myBot.sendMessage(msg, "lock is unlocked");       // notify the sender
		}
		else {                                                    // otherwise...
		
			String reply;
			reply = "Welcome " ;
			reply += msg.sender.username;
			reply += ".\nTry create otp to unlockdoor";
			myBot.sendMessage(msg, reply);             // and send it
		}
	}
	
}
