#include <esp_now.h>
#include <WiFi.h>


int count = 0;
// Structure example to receive data
// Must match the sender structure
typedef struct struct_message {
    char a[32];
    int b;
    float c;
    bool d;
} struct_message;

// Create a struct_message called myData
struct_message myData;

// callback function that will be executed when data is received
void OnDataRecv(const uint8_t * mac, const uint8_t *incomingData, int len) {
  memcpy(&myData, incomingData, sizeof(myData));
  Serial.print("Bytes received: ");
  Serial.println(len);
  Serial.print("Char: ");
  Serial.println(myData.a);
  Serial.print("Int: ");
  Serial.println(myData.b);
  Serial.println();


  if(myData.b == 1){
    digitalWrite(2,HIGH);
    count =0;
    
  }

  if(myData.b == 0){
    digitalWrite(2,LOW);
    count =0;
    
  }
}
 
void setup() {
  // Initialize Serial Monitor
  Serial.begin(115200);
  pinMode(2,OUTPUT);
  // Set device as a Wi-Fi Station
  WiFi.mode(WIFI_STA);

  // Init ESP-NOW
  if (esp_now_init() != ESP_OK) {
    Serial.println("Error initializing ESP-NOW");
    
    return;
  }
  
  // Once ESPNow is successfully Init, we will register for recv CB to
  // get recv packer info
  esp_now_register_recv_cb(OnDataRecv);
}
 
void loop() {

  count++;
  delay(1000);


  if(count >= 10){

    digitalWrite(2,LOW);
    count = 0;

  }

}
