#include "SevSeg.h"
#include <OneWire.h>
#include <DallasTemperature.h>

#define ONE_WIRE_BUS 1
#define heater_relay_pin 19
#define set_butn_pin 15
#define on_butn_pin 16 
#define pot_pin A0
#define on_led_pin 17
#define off_led_pin 18
#define buzzer 0

OneWire oneWire(ONE_WIRE_BUS);  

DallasTemperature sensors(&oneWire);
SevSeg sevseg; 
unsigned long t;
int count=0,new_water_temp,water_tmp_set;
bool temp_set_flag = 0,heater_on_flag=0;
float water_temp; 
void set_water_temp()
 {
   int t = analogRead(pot_pin);
   new_water_temp = map(t,0,1023,40,80);
   sevseg.setNumber(new_water_temp,0);
 }
void heater_on()
 {
      digitalWrite(heater_relay_pin,1);
      digitalWrite(on_led_pin,1);
      digitalWrite(off_led_pin,0);  
      delay(200);
      t = millis();
      heater_on_flag=1;
 } 
void heater_off()
 {
      digitalWrite(buzzer,1);
      digitalWrite(heater_relay_pin,0);
      digitalWrite(on_led_pin,0);
      digitalWrite(off_led_pin,1);  
      heater_on_flag=0;  
      delay(500); 
      digitalWrite(buzzer,0);   
 }  
void display_water_tmp()
  {
    sensors.requestTemperatures(); 
    water_temp = sensors.getTempCByIndex(0);
    Serial.print("Water temperature: ");
    Serial.print(water_temp);  
    Serial.println(" deg C");  
    sevseg.setNumberF(water_temp, 2);
  }   
 
void setup()
{
  byte numDigits = 4;
  byte digitPins[] = {13, 12, 11, 10};
  byte segmentPins[] = {9,8,7,6,5,4,3,2};
  byte hardwareConfig = COMMON_CATHODE;
  pinMode(set_butn_pin, INPUT);
  pinMode(on_butn_pin, INPUT); 
  pinMode(on_led_pin, OUTPUT);  
  pinMode(off_led_pin, OUTPUT);  
  pinMode(heater_relay_pin, OUTPUT);    
  sevseg.begin(hardwareConfig, numDigits, digitPins, segmentPins);  
  sensors.begin();  // Start up the library
  Serial.begin(9600);
  digitalWrite(heater_relay_pin,0);
  digitalWrite(on_led_pin,0);
  digitalWrite(off_led_pin,1);  
}

void loop()
{
  if(digitalRead(set_butn_pin)==0)
    {
      count++;
      if(count%2 == 1) temp_set_flag = 1;
      else 
       {
         temp_set_flag = 0; 
         water_tmp_set = new_water_temp;
         sevseg.setNumber(water_tmp_set,0);
       }
       delay(200);
     }
  if(temp_set_flag) set_water_temp(); 
  if(digitalRead(on_butn_pin)==0) heater_on();  
  if(heater_on_flag)
    {
      if(millis() - t >= 1000)
        {
          t+=1000;
          display_water_tmp();
        }  
    }   
  if(int(water_temp)>=water_tmp_set) heater_off();  
  sevseg.refreshDisplay();   
}
