#include <ESP8266WiFi.h>
#include <WiFiClientSecure.h>

#define ON_Board_LED 2

const char* ssid = "JioFiber-4G";
const char* password = "1234567890";

const char* host = "script.google.com";
const int httpsPort = 443;

WiFiClientSecure client;

String GAS_ID = "AKfycbyI8wCr-nVSMpf1UVqGoRRl7k8cNxR5w_1BxwfjayeyXLVm2V7Wa7vDLqmCr7qgB52VAw";
//https://script.google.com/u/0/home/projects/10TnKbgOgybueecHtorjNydJJWPwqHjY8lseD3BEGDVKNQjdVSTbfhUjp/edit
//https://script.google.com/macros/s/AKfycbxXTIqABHc69PTfOCNybBgfpeqkYtQSlSnxowybQ88h/dev/exec?temperature=35.00&airpressure=110&spo2=90.00&pulse=85&timestamp=1970-01-01 01:00:19
//AKfycbyI8wCr-nVSMpf1UVqGoRRl7k8cNxR5w_1BxwfjayeyXLVm2V7Wa7vDLqmCr7qgB52VAw
//https://script.googleusercontent.com/macros/echo?0TnKbgOgybueecHtorjNydJJWPwqHjY8lseD3BEGDVKNQjdVSTbfhUjp

//https://script.google.com/macros/s/AKfycbyI8wCr-nVSMpf1UVqGoRRl7k8cNxR5w_1BxwfjayeyXLVm2V7Wa7vDLqmCr7qgB52VAw/exec

//https://script.google.com/macros/s/AKfycbyI8wCr-nVSMpf1UVqGoRRl7k8cNxR5w_1BxwfjayeyXLVm2V7Wa7vDLqmCr7qgB52VAw/exec
void setup() {
  Serial.begin(115200);
  delay(500);
  WiFi.begin(ssid, password);
  Serial.println("");
  pinMode(ON_Board_LED, OUTPUT);
  digitalWrite(ON_Board_LED, HIGH);

  Serial.print("Connecting");
  while (WiFi.status() != WL_CONNECTED) {
    Serial.print(".");
    digitalWrite(ON_Board_LED, LOW);
    delay(250);
    digitalWrite(ON_Board_LED, HIGH);
    delay(250);
  }

  digitalWrite(ON_Board_LED, HIGH);
  Serial.println("");
  Serial.print("Successfully connected to: ");
  Serial.println(ssid);
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());
  Serial.println();

  client.setInsecure();
}

void loop() {
  int pulse = random(80,90);//readPulse();
  float spo2 = random(90,98);//readSPO2();
  float temperature =random(33,36); //readTemperature();
  int airpressure = random(110,120);//readHumidity();

  if (isnan(pulse) || isnan(spo2) || isnan(temperature) || isnan(airpressure)) {
    Serial.println("Failed to read sensor data!");
    delay(1000);
    return;
  }

  sendData(temperature, airpressure, spo2, pulse);
  delay(5000); // Adjust the delay based on how frequently you want to update the Google Sheet
}

void sendData(float temperature, int airpressure, float spo2, int pulse) {
  Serial.println("==========");
  Serial.print("Connecting to ");
  Serial.println(host);

  if (!client.connect(host, httpsPort)) {
    Serial.println("Connection failed!");
    return;
  }

  String timestamp = getTimeStamp();

  String url = "/macros/s/" + GAS_ID + "/exec?temperature=" + String(temperature) + "&airpressure=" + String(airpressure) +
               "&spo2=" + String(spo2) + "&pulse=" + String(pulse) + "&timestamp=" + timestamp;
  Serial.print("Requesting URL: ");
  Serial.println(url);

  client.print(String("GET ") + url + " HTTP/1.1\r\n" +
               "Host: " + host + "\r\n" +
               "User-Agent: ESP8266\r\n" +
               "Connection: close\r\n\r\n");

  Serial.println("Request sent");

  while (client.connected()) {
    String line = client.readStringUntil('\n');
    if (line == "\r") {
      Serial.println("Headers received");
      break;
    }
  }

  String line = client.readStringUntil('\n');
  if (line.startsWith("{\"state\":\"success\"")) {
    Serial.println("Data sent to Google Sheets successfully");
  } else {
    Serial.println("Failed to send data to Google Sheets");
  }
  Serial.print("Reply: ");
  Serial.println(line);
  Serial.println("Closing connection");
}

String getTimeStamp() {
  time_t now = time(nullptr) + 3600;
  struct tm* timeinfo;
  timeinfo = gmtime(&now);

  char buffer[20];
  strftime(buffer, sizeof(buffer), "%Y-%m-%d %H:%M:%S", timeinfo);

  return String(buffer);
}
