import rdm6300
import csv
import datetime

reader = rdm6300.Reader('/dev/cu.usbserial-1110')
csv_filename = 'rfid_data.csv'
csv_header = ['RFID', 'Name', 'Date', 'Time']

# Write the CSV header if the file doesn't exist
try:
    with open(csv_filename, 'x', newline='') as csvfile:
        csv_writer = csv.writer(csvfile)
        csv_writer.writerow(csv_header)
except FileExistsError:
    pass  # File already exists, no need to create header again

def find_rfid_data(rfid):
    with open(csv_filename, 'r', newline='') as csvfile:
        csv_reader = csv.reader(csvfile)
        for row in csv_reader:
            if row[0] == rfid:
                return row[1:]  # Return Name, Date, Time
    return None

print("Please insert an RFID card")

while True:
    card = reader.read()
    if card:
        rfid = card.value
        existing_data = find_rfid_data(rfid)
        
        if existing_data:
            name, date, time = existing_data
            print("RFID {} already exists with name {} on {} at {}".format(rfid, name, date, time))
        else:
            name = input("Enter a name for the RFID {}: ".format(rfid))
            date = datetime.datetime.now().strftime('%Y-%m-%d')
            time = datetime.datetime.now().strftime('%H:%M:%S')

            with open(csv_filename, 'a', newline='') as csvfile:
                csv_writer = csv.writer(csvfile)
                csv_writer.writerow([rfid, name, date, time])

            print("RFID {} saved with name {} on {} at {}".format(rfid, name, date, time))
