import cv2
import dlib
import numpy as np

# Initialize the face detector and shape predictor from dlib
detector = dlib.get_frontal_face_detector()
predictor = dlib.shape_predictor("shape_predictor_68_face_landmarks.dat")  # You need to provide the correct path

# Main loop for face landmark visualization
cap = cv2.VideoCapture(0)  # Use camera with index 0
while True:
    ret, frame = cap.read()
    if not ret:
        break

    # Convert frame to grayscale for face detection
    gray = cv2.cvtColor(frame, cv2.COLOR_BGR2GRAY)

    # Detect faces in the grayscale frame
    faces = detector(gray)

    for face in faces:
        # Get facial landmarks
        landmarks = predictor(gray, face)
        
        # Convert landmarks to numpy array for easier indexing
        landmarks_np = np.array([[landmark.x, landmark.y] for landmark in landmarks.parts()])
        
        # Draw rectangles around lips, left eye, right eye, left eyebrow, and right eyebrow
        lips_rect = cv2.boundingRect(landmarks_np[48:68])  # Lips
        left_eye_rect = cv2.boundingRect(landmarks_np[36:42])  # Left Eye
        right_eye_rect = cv2.boundingRect(landmarks_np[42:48])  # Right Eye
        left_eyebrow_rect = cv2.boundingRect(landmarks_np[17:22])  # Left Eyebrow
        right_eyebrow_rect = cv2.boundingRect(landmarks_np[22:27])  # Right Eyebrow
        
        cv2.rectangle(frame, (lips_rect[0], lips_rect[1]), (lips_rect[0] + lips_rect[2], lips_rect[1] + lips_rect[3]), (255, 0, 0), 2)
        cv2.rectangle(frame, (left_eye_rect[0], left_eye_rect[1]), (left_eye_rect[0] + left_eye_rect[2], left_eye_rect[1] + left_eye_rect[3]), (0, 255, 0), 2)
        cv2.rectangle(frame, (right_eye_rect[0], right_eye_rect[1]), (right_eye_rect[0] + right_eye_rect[2], right_eye_rect[1] + right_eye_rect[3]), (0, 255, 0), 2)
        cv2.rectangle(frame, (left_eyebrow_rect[0], left_eyebrow_rect[1]), (left_eyebrow_rect[0] + left_eyebrow_rect[2], left_eyebrow_rect[1] + left_eyebrow_rect[3]), (0, 0, 255), 2)
        cv2.rectangle(frame, (right_eyebrow_rect[0], right_eyebrow_rect[1]), (right_eyebrow_rect[0] + right_eyebrow_rect[2], right_eyebrow_rect[1] + right_eyebrow_rect[3]), (0, 0, 255), 2)

    cv2.imshow("Face Landmark Visualization", frame)
    
    # Exit the loop when 'q' is pressed
    if cv2.waitKey(1) & 0xFF == ord('q'):
        break

# Release resources
cap.release()
cv2.destroyAllWindows()
