import telepot
from picamera import PiCamera
import RPi.GPIO as GPIO
import time
from time import sleep
from telepot.loop import MessageLoop
from subprocess import call

PIR = 7
camera = PiCamera()
camera.resolution = (640, 480)
camera.framerate = 25
GPIO.setwarnings(False)
GPIO.setmode(GPIO.BOARD)
GPIO.setup(PIR, GPIO.IN)
motion = 0
motionNew = 0


def handle(msg):
    global telegramText
    global chat_id
    chat_id = msg['chat']['id']
    telegramText = msg['text']
    print('Message received from ' + str(chat_id))
    if telegramText == '/start' or telegramText == '/Start' or telegramText == '/ON' or telegramText == '/on':
        bot.sendMessage(chat_id, 'Security camera is activated.')  # Put your welcome note here


def main():
    global chat_id
    global motion
    global motionNew

    if GPIO.input(PIR) == 1:
        print("Motion detected")
        motion = 1

    if motionNew != motion:
        motionNew = motion
        sendNotification(motion)
    elif GPIO.input(PIR) == 0:
        print("No motion detected")
        motion = 0

    if motionNew != motion:
        motionNew = motion


def sendNotification(motion):
    global chat_id
    if motion == 1:
        filename = "/home/pi/Desktop/" + (time.strftime("%y%b%d_%H%M%S"))  # default folder
        camera.start_recording(filename + ".h264")
        sleep(5)
        camera.stop_recording()
        command = "MP4Box -add " + filename + '.h264' + " " + filename + '.mp4'  # Convert .H264 to MP4
        print(command)
        call([command], shell=True)
        bot.sendVideo(chat_id, video=open(filename + '.mp4', 'rb'))
        bot.sendMessage(chat_id, 'The motion sensor is triggered!')  # Message displayed on Telegram screen


while True:
    main()

bot = telepot.Bot('**********:**********************_************')  # API key
bot.message_loop(handle)

while 1:
    time.sleep(5)
