#include <WiFi.h>
#include <HTTPClient.h>
#include <ArduinoJson.h>

const char *ssid = "IRONMAN";
const char *password = "1234567890";

#include <Arduino_GFX_Library.h>

Arduino_DataBus *bus = new Arduino_ESP32SPI( 3/* DC */, 2 /* CS */, 1/* SCK */, 21/* MOSI */, -1 /* MISO */);
Arduino_GFX *gfx = new Arduino_GC9A01(bus, 4 /* RST */, 3 /* rotation */, true /* IPS */);



/*******************************************************************************
 * End of Arduino_GFX setting
 ******************************************************************************/

/* more fonts at: https://github.com/moononournation/ArduinoFreeFontFile.git */
#include "FreeMono8pt7b.h"
#include "FreeSansBold10pt7b.h"
#include "FreeSerifBoldItalic12pt7b.h"

void setup(void)
{
  Serial.begin(115200);
  // Serial.setDebugOutput(true);
  // while(!Serial);
  Serial.println("Arduino_GFX Hello World Gfxfont example");

#ifdef GFX_EXTRA_PRE_INIT
  GFX_EXTRA_PRE_INIT();
#endif

  // Init Display
  if (!gfx->begin())
  {
    Serial.println("gfx->begin() failed!");
  }
  gfx->fillScreen(BLACK);

#ifdef GFX_BL
  pinMode(GFX_BL, OUTPUT);
  digitalWrite(GFX_BL, HIGH);
#endif

  gfx->setCursor(0, 20);
  gfx->setFont(&FreeMono8pt7b);
  gfx->setTextColor(WHITE);
  gfx->println("Connecting To Wifi");

  delay(5000); // 5 seconds
   connectToWiFi();
}

void loop()
{
  
  delay(1000); // 1 second
}

void connectToWiFi() {
  Serial.println("Connecting to WiFi...");
  WiFi.begin(ssid, password);


  while (WiFi.status() != WL_CONNECTED) {
    delay(1000);
    Serial.println("Connecting...");
    gfx->println("Connecting...");

  }

  Serial.println("Connected to WiFi");
  gfx->fillScreen(BLACK);
  gfx->setCursor(0, 20);
  gfx->println("Connected");
 

  // Once connected, get the IP address and use it to get the location
  Serial.print("IP Address: ");
  Serial.println(WiFi.localIP());
   gfx->println(WiFi.localIP());
   
   // Call the function to get the location using the obtained IP address
  getLocation();
}
void getLocation() {
  HTTPClient http;

  // Get the public IP address of the device
  String url = "https://api.ipify.org";
  http.begin(url);

  int httpResponseCode = http.GET();

  if (httpResponseCode == HTTP_CODE_OK) {
    String ipAddress = http.getString();

    // Construct the URL using the public IP address
    String locationUrl = "https://ipapi.co/" + ipAddress + "/json/";

    http.begin(locationUrl);

    int locationResponseCode = http.GET();

    if (locationResponseCode == HTTP_CODE_OK) {
      String payload = http.getString();
      Serial.println(payload);
      String scrollText = payload;
      int scrollSpeed = 1; // Adjust scroll speed as needed
      int scrollPos = 240;



      // Parse JSON response
      DynamicJsonDocument doc(1024);
      deserializeJson(doc, payload);

      String country = doc["country_name"].as<String>();
      String region = doc["region"].as<String>();
      String city = doc["city"].as<String>();
      double latitude = doc["latitude"].as<double>();
      double longitude = doc["longitude"].as<double>();

      Serial.println("Location:");
      Serial.print("Country: ");
      Serial.println(country);
      Serial.print("Region: ");
      Serial.println(region);
      Serial.print("City: ");
      Serial.println(city);
      Serial.print("Latitude: ");
      Serial.println(latitude, 7);
      Serial.print("Longitude: ");
      Serial.println(longitude, 7);
      gfx->fillScreen(BLACK);
      gfx->setCursor(0, 20);
      gfx->setTextColor(WHITE);
      gfx->println(scrollText);
      scrollPos -= scrollSpeed;
      if (scrollPos < - 240) {
        scrollPos = 240;
       }
       delay(50);

    // gfx->println("Location: Lat,Long");
    // gfx->println(latitude +"," longitude);
    // gfx->println("Country-"+ str(country ));
    // gfx->println(city);         

    } else {
      Serial.print("Error getting location. HTTP error code: ");
      Serial.println(locationResponseCode);
    }
  } else {
    Serial.print("Error getting public IP address. HTTP error code: ");
    Serial.println(httpResponseCode);
  }

  http.end();
}

