#include <Wire.h>
#include <TFT_eSPI.h>
#include <CST816S.h>

#include "USB.h"
#include "USBHIDKeyboard.h"
USBHIDKeyboard Keyboard;

// 
// #define TFT_MOSI 15 // In some display driver board, it might be written as "SDA" and so on.
// #define TFT_SCLK 14
// #define TFT_CS   5  // Chip select control pin
// #define TFT_DC   27  // Data Command control pin
// #define TFT_RST  33  // Reset pin (could connect to Arduino RESET pin)
// #define TFT_BL   23 
TFT_eSPI tft = TFT_eSPI();  // Use default SPI pins
CST816S touch(5, 6, 10, 7); // sda, scl, rst, irq

// Keyboard parameters
int keySizeX = 40;  // Width of each key
int keySizeY = 30;  // Height of each key
int keyboardWidth = 6 * keySizeX;
int keyboardHeight = 4 * keySizeY;

String typedText = "";  // String to store typed letters. //         

void setup() {
  Serial.begin(115200);
Keyboard.begin();
  USB.begin();
  // Initialize the display
  tft.init();
  tft.setRotation(0);  // Set the rotation as needed

  // Initialize the touch controller
  touch.begin();

  // Set the background color
  tft.fillScreen(TFT_BLACK);

  // Draw the keyboard higher up on the display
  int keyboardX = (tft.width() - keyboardWidth) / 2;
  int keyboardY = (tft.height() - keyboardHeight) / 3;  // Adjusted to move the keyboard up

  // Draw red boundary lines
  tft.drawFastHLine(keyboardX, keyboardY - 1, keyboardWidth, TFT_RED);
  tft.drawFastHLine(keyboardX, keyboardY + keyboardHeight, keyboardWidth, TFT_RED);
  tft.drawFastVLine(keyboardX - 1, keyboardY, keyboardHeight, TFT_RED);
  tft.drawFastVLine(keyboardX + keyboardWidth, keyboardY, keyboardHeight, TFT_RED);

  for (int row = 0; row < 4; row++) {
    for (int col = 0; col < 6; col++) {
      char key = 'A' + (row * 6) + col;
      drawKey(keyboardX + col * keySizeX, keyboardY + row * keySizeY, key);
    }
  }
}

void drawKey(int x, int y, char key) {
  tft.fillRoundRect(x, y, keySizeX, keySizeY, 5, TFT_BLACK); // Black key button background
  tft.drawFastHLine(x, y + keySizeY, keySizeX, TFT_RED); // Red bottom boundary line
  tft.drawFastVLine(x + keySizeX, y, keySizeY, TFT_RED); // Red right boundary line
  tft.setTextColor(TFT_WHITE); // White text color
  tft.setTextSize(2);
  tft.setCursor(x + keySizeX / 4, y + keySizeY / 4);
  tft.print(key);
}

void loop() {
  if (touch.available()) {
    int touchX = touch.data.x;
    int touchY = touch.data.y;

    for (int row = 0; row < 4; row++) {
      for (int col = 0; col < 6; col++) {
        int keyX = (tft.width() - keyboardWidth) / 2 + col * keySizeX;
        int keyY = (tft.height() - keyboardHeight) / 3 + row * keySizeY;

        if (touchX >= keyX && touchX < keyX + keySizeX && touchY >= keyY && touchY < keyY + keySizeY) {
          char touchedKey = 'A' + (row * 6) + col;
          Serial.println("Touched key: " + String(touchedKey));
          typedText += touchedKey;
          displayTypedText();
          char inChar = touchedKey;
    // Type the next ASCII value from what you received:
         Keyboard.write(inChar + 1);
        }
      }
    }
  }
}

void displayTypedText() {
  tft.setTextSize(3);
  int textWidth = tft.textWidth(typedText);
  int textX = (tft.width() - textWidth) / 2;
  int textY = (tft.height() - keyboardHeight) / 3 - keySizeY;  // Above the keyboard
  tft.setCursor(textX, textY);
  tft.setTextColor(TFT_WHITE);
  tft.print(typedText);
  
}
