const int wakeupPin = 4; // GPIO 4 for external wake-up
RTC_DATA_ATTR int bootCount = 0; // Number of reboots
int pHSense = 35;//p0
int samples = 10;
float adc_resolution = 4095.0; //ESP 32 12 bit ADC Resolution
int measurings=0;
float ph (float voltage)
{
return 7 + ((2.50 - voltage) / 0.18);
}
void setup()
{
Serial.begin(115200); // Start serial port at 115200 baud rate
pinMode(wakeupPin, INPUT_PULLUP); // Declare touch sensor pin as INPUT_PULLUP
bootCount++; // Increment the number of boots by 1
Serial.println("Boot number: " + String(bootCount)); // Print the boot number at execution
for (int i = 0; i < samples; i++)
{
measurings += analogRead(pHSense);
delay(10);
}
float voltage = 3.3 / adc_resolution * measurings/samples;
Serial.print("pH= ");
Serial.println(ph(voltage));
delay(1000);
esp_sleep_enable_ext0_wakeup((gpio_num_t)wakeupPin, HIGH); // Configure ext wakeup
delay(1000); // Adding a 1 second delay to avoid multiple presses
Serial.println("I'm going to sleep now.");// Print the statement before entering deep sleep
esp_deep_sleep_start(); // Enter deep sleep mode
}
void loop()
{
//We will never use loop
}