#include <PS2Keyboard.h>
#include <WiFi.h>
#include <HTTPClient.h>
#include <ArduinoJson.h>

#include <SPI.h>
#include <TFT_eSPI.h> // Hardware-specific library

//#include "Arduino.h"
#include "Audio.h"
#define I2S_DOUT  21 //    25
#define I2S_BCLK  22 //    27
#define I2S_LRC   23 //    26


TFT_eSPI tft = TFT_eSPI();       // Invoke custom library
//unsigned int colour = red << 11; // Colour order is RGB 5+6+5 bits each
Audio audio;



const int DataPin = 35;  //19;
const int IRQpin =  34;   //18;
PS2Keyboard keyboard;

byte x, y;  // track lcd position
int datalength;

int a=0;
int b=5;
String msg="";
const char backslash = 3;
char c;

const char* ssid = "*****";
const char* password = "******************";
const char* api_key = "********************************";

void connectToWiFi() {
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(1000);
    Serial.println("Connecting to WiFi...");
  }
  Serial.println("Connected to WiFi!");
}

// currently un-used:
#define is_printable(c) (!(c&0x80))   // don't print if top bit is set

void setup() {
  delay(300);
  keyboard.begin(DataPin, IRQpin);
  Serial.begin(115200);
  tft.init();
  audio.setPinout(I2S_BCLK, I2S_LRC, I2S_DOUT);
  audio.setVolume(50);

  tft.setRotation(2);
  tft.fillScreen(TFT_BLACK);
  tft.setTextFont(2);        // Select font 4 without moving cursor
  tft.setCursor(00, 00);    // Set cursor to x = 90, y = 210 without changing the font
   
 tft.setTextColor(TFT_GREENYELLOW, TFT_BLACK);  // Set text colour to white and background to black
 tft.println("Write question:");
 connectToWiFi();
  while (!Serial) yield();
  Serial.println(F("Keyboard Test:"));
  }

String makeApiRequest(String prompt1 ) {
  HTTPClient http;
  http.setTimeout(24000); // 240000 Set a longer timeout (in milliseconds)
  http.begin("https://api.openai.com/v1/chat/completions");
  http.addHeader("Content-Type", "application/json");
  http.addHeader("Authorization", "Bearer " + String(api_key));
  
  StaticJsonDocument<1024> jsonPayload;
  jsonPayload["model"] = "gpt-3.5-turbo"; //text-davinci-003"; //gpt-3.5-turbo";
  jsonPayload["temperature"] = 0.8;
  jsonPayload["max_tokens"] = 2000;

  JsonArray messages = jsonPayload.createNestedArray("messages");
  JsonObject userMessage = messages.createNestedObject();
  userMessage["role"] = "user";
  userMessage["content"] = prompt1;
  
  String payloadString;
  serializeJson(jsonPayload, payloadString);
  
  int httpResponseCode = http.POST(payloadString);
  if (httpResponseCode == HTTP_CODE_OK) {
    String response = http.getString();

    StaticJsonDocument<1024> jsonResponse;
    deserializeJson(jsonResponse, response);

    String assistantReply = jsonResponse["choices"][0]["message"]["content"].as<String>();
    return assistantReply;
  } 
  else {
    Serial.print("HTTP Request failed, error code: ");
    Serial.println(httpResponseCode);
    return "";
  }
  http.end();
}

int pos=0;
int pos1=0;
int pos2=0;
#define hcon 5.8182

void loop() {
 // while (!keyboard.available()) audio.loop();
  while (!Serial.available() and !keyboard.available() ) audio.loop();
 
  if (keyboard.available()) {
        c = keyboard.read();
        Serial.print(c);
        pos1=pos1+1;
     int l=msg.length();
      tft.print(c);
  
    if (c == PS2_TAB)       Serial.println(F("[Tab]"));
    else if (c == PS2_ESC)      Serial.println(F("\n[ESC]\n"));
    else if (c == PS2_PAGEDOWN)       Serial.println(F("[PgDn]"));
    else if (c == PS2_PAGEUP)       Serial.println(F("[PgUp]"));
    else if (c == PS2_LEFTARROW)       Serial.println(F("[Left]"));
    else if (c == PS2_RIGHTARROW)       Serial.println(F("[Right]"));
    else if (c == PS2_UPARROW)       Serial.println(F("[Up]"));
    else if (c == PS2_DOWNARROW)       Serial.println(F("[Down]"));
    else if (c == PS2_DELETE)       Serial.println(F("[Del]"));
    else if (c == PS2_BACKSPACE)        Serial.println(F("[Back]"));
      
   else {
     msg=msg+String(c);
    }

if (c == PS2_ENTER) {
//  Serial.println(msg);
  String response = makeApiRequest(msg);
  String response1;
  //Serial.println(prompt1);
  Serial.print("Response: ");
  Serial.println(response);
  tft.fillScreen(TFT_BLACK);
  tft.setTextFont(2);        
 tft.setCursor(00, 00);    
tft.print(msg);
tft.print(":");
  int l1 = response.length();
  Serial.println(l1);
  Serial.println(response);
  tft.println(l1);
  tft.setTextColor(TFT_YELLOW, TFT_BLACK);  // Set text colour to white and background to black
  tft.println(response);
  if (l1>200) {
  response = response.substring(0, 200);
  }
  audio.connecttospeech(response.c_str(), "en"); // cancel any speeches beyond 200 charracters.
}
if (c == PS2_ESC) {
msg="";
tft.fillScreen(TFT_BLACK);
tft.setCursor(0,0);    // Set cursor to x = 90, y = 210 without changing the font
tft.setTextColor(TFT_GREENYELLOW, TFT_BLACK);  // Set text colour to white and background to black
tft.println("Write question:");
} 

  }

}
// this is optional, to see the output & error messages of the I2S amplifier
void audio_info(const char *info) {
  Serial.print("audio_info: "); Serial.println(info);
}
