#include <SoftwareSerial.h>

// Define the RX and TX pins for the SoftwareSerial interface
#define GPS_TX_PIN 2
#define GPS_RX_PIN 3

// Create a SoftwareSerial object for communication with the NEO-6M GPS module
SoftwareSerial gpsSerial(GPS_RX_PIN, GPS_TX_PIN);

void setup() {
  // Initialize serial communication with the computer
  Serial.begin(9600);
  
  // Initialize serial communication with the GPS module
  gpsSerial.begin(9600);
}

void loop() {
  // Read data from the GPS module and send it to the computer
  if (gpsSerial.available()) {
    char c = gpsSerial.read();
    Serial.write(c);
  }
  
  // Read data from the computer and send it to the GPS module
  if (Serial.available()) {
    char c = Serial.read();
    gpsSerial.write(c);
  }
}
